#include "tsimplestorage.h"

TSimpleStorage::TSimpleStorage() {
    LogsGroup = NULL;
    data_filename = "";
    m_LastTimestamp = 0;
    m_LastSize = 0;
    m_lastloadevent = "";
    mode = MUNKNOWN;
}

TSimpleStorage::~TSimpleStorage() {
}

bool TSimpleStorage::InitBeforeFork(TShinglerSrvMode modeA, TKConfig* configA, TLogsGroup* LogsGroupA) {
    bool res = true;

    mode = modeA;
    LogsGroup = LogsGroupA;
    if (configA != NULL)
        data_filename = configA->ReadStroka("storage", "data_filename", "");

    if ((mode != MPROXY) && (data_filename.empty())) {
        if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
            LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KERROR, "No defined data filename.");
        res = false;
    }

    return res;
}

bool TSimpleStorage::InitAfterFork() {
    return true;
}

bool TSimpleStorage::Get(const ui64 Key, TString& Value) {
    bool flag_ok = true;
    m_Mutex.Acquire();

    THash::iterator i = m_Hash.find(Key);
    if (i != m_Hash.end())
        Value = (*i).second;
    else {
        Value = "";
        flag_ok = false;
    }

    m_Mutex.Release();
    return flag_ok;
}

bool TSimpleStorage::Add(const ui64 Key, TString Value) {
    bool flag_ok = true;
    m_Mutex.Acquire();

    THash::iterator i = m_Hash.find(Key);
    if (i != m_Hash.end()) {
        (*i).second = Value;
    } else {
        m_Hash[Key] = Value;
    }

    m_Mutex.Release();
    return flag_ok;
}

bool TSimpleStorage::Load(ui32& ecount, ui32& edublicat) {
    if (mode == MPROXY) {
        if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
            LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KMESSAGE, "Skeep loading storage in PROXY mode.");
        return true;

    } else {
        m_Mutex.Acquire();

        char *e = NULL, *b = NULL;
        ui64 timestamp = 0;
        ui64 file_size = 0;
        ui64 key = 0;
        bool flag_ok = true;
        THashIt it;
        ui32 dublicat = 0;
        ui32 reccount = 0;
        FILE* m_File = NULL;

        ecount = 0;
        edublicat = 0;

        if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
            LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KMESSAGE, "Loading storage from file '%s'", data_filename.c_str());
        // printf("STORAGE: Loading storage from file '%s'\n", data_filename.c_str());

        m_File = fopen(data_filename.c_str(), "r");
        if (NULL == m_File) {
            if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
                LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KERROR, "Can't open storage data file '%s'", data_filename.c_str());
            m_lastloadevent = "[" + TimeToStr(time(NULL)) + "] Can't open storage data file " + data_filename;
            m_Mutex.Release();
            return false;
        }

        fgets(m_RecordBuffer, MAX_RECORD_SIZE, m_File);
        e = strchr(m_RecordBuffer, '\n');
        if (NULL == e) {
            if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
                LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KERROR, "Can't read 'timestamp' from storage data file '%s'", data_filename.c_str());
            fclose(m_File);
            m_lastloadevent = "[" + TimeToStr(time(NULL)) + "] Can't read 'timestamp' from storage data file " + data_filename;
            m_Mutex.Release();
            return false;
        }

        timestamp = strtoull(m_RecordBuffer, &e, 10);

        if (m_LastTimestamp == timestamp) {
            file_size = GetFileSize();

            if (m_LastSize != file_size) {
                fsetpos(m_File, &m_LastPosition);
                m_LastSize = file_size;
            } else {
                fclose(m_File);
                m_lastloadevent = "[" + TimeToStr(time(NULL)) + "] Loading storage compleate, count=" + IntToStroka(reccount) + ", dublicat=" + IntToStroka(dublicat) + ".";
                m_Mutex.Release();

                if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
                    LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KMESSAGE, "Storage not changed '%s'.", data_filename.c_str());

                return true;
            }
        } else {
            m_LastTimestamp = timestamp;
            m_LastSize = GetFileSize();
            m_Hash.clear();
        }

        while (fgets(m_RecordBuffer, MAX_RECORD_SIZE, m_File)) {
            b = m_RecordBuffer;
            e = strchr(m_RecordBuffer, ' ');
            if (NULL == e) {
                if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
                    LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KERROR, "Can't read 'key' from storage data file '%s'", data_filename.c_str());
                m_lastloadevent = "[" + TimeToStr(time(NULL)) + "] Can't read 'key' from storage data file " + data_filename;
                flag_ok = false;
                break;
            }
            key = strtoull(b, &e, 16);

            b = ++e;
            e = strchr(m_RecordBuffer, '\n');
            if (NULL == e) {
                if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
                    LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KERROR, "Error reading value from file '%s'", data_filename.c_str());
                m_lastloadevent = "[" + TimeToStr(time(NULL)) + "] Error reading value from file " + data_filename;
                flag_ok = false;
                break;
            }
            *e = '\0';

            it = m_Hash.find(key);
            if (it != m_Hash.end()) {
                (*it).second = TString(b);
                dublicat++;
            } else
                m_Hash.insert(THash::value_type(key, TString(b)));

            fgetpos(m_File, &m_LastPosition);
        }

        fclose(m_File);
        m_Mutex.Release();

        reccount = m_Hash.size();
        ecount = reccount;
        edublicat = dublicat;
        if (flag_ok) {
            if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
                LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KMESSAGE, "Loading storage compleate, count=%u, dublicat=%u.", reccount, dublicat);
            m_lastloadevent = "[" + TimeToStr(time(NULL)) + "] Loading storage compleate, count=" + IntToStroka(reccount) + ", dublicat=" + IntToStroka(dublicat) + ".";
            // printf("STORAGE: Loading storage complete, count=%u, dublicat=%u.\n", reccount, dublicat);
        } else {
            if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
                LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KERROR, "Loading storage failed, count=%u, dublicat=%u.", reccount, dublicat);
            m_lastloadevent = "[" + TimeToStr(time(NULL)) + "] Loading storage failed, count=" + IntToStroka(reccount) + ", dublicat=" + IntToStroka(dublicat) + ".";
            // printf("STORAGE: Loading storage failed, count=%u, dublicat=%u.\n", reccount, dublicat);
        }

        return flag_ok;
    }
}

void TSimpleStorage::Clear() {
    m_Hash.clear();
}

ui64 TSimpleStorage::GetFileSize() {
    ui64 res = 0;

    if (!data_filename.empty()) {
        struct stat fs;
        stat(data_filename.c_str(), &fs);
        res = fs.st_size;
    }

    return res;
}

TSimpleStorageStat TSimpleStorage::GetStat() {
    TSimpleStorageStat res;

    res.last_load_stat = m_lastloadevent;
    res.record_count = m_Hash.size();

    return res;
}
