#pragma once

#include "util/system/mutex.h"
#include "util/generic/string.h"
#include "util/system/defaults.h"
#include "util/generic/hash.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include "tlogsgroup.h"
#include "tgeneralclasses.h"

struct TSimpleStorageStat {
    TString last_load_stat;
    ui32 record_count;

    TSimpleStorageStat() {
        Clear();
    }

    void Clear() {
        last_load_stat = "";
        record_count = 0;
    }
};

class TSimpleStorage {
private:
    typedef THashMap<ui64, TString> THash;
    typedef THash::iterator THashIt;

    static const ui16 MAX_RECORD_SIZE = 1024;

private:
    THash m_Hash;
    TLogsGroup* LogsGroup;
    TString data_filename;
    TMutex m_Mutex;
    TShinglerSrvMode mode;

    TString m_lastloadevent;
    ui64 m_LastTimestamp;
    ui64 m_LastSize;
    fpos_t m_LastPosition;
    char m_RecordBuffer[MAX_RECORD_SIZE];

    ui64 GetFileSize();

public:
    TSimpleStorage();
    ~TSimpleStorage();

    bool InitBeforeFork(TShinglerSrvMode modeA, TKConfig* configA, TLogsGroup* LogsGroupA);
    bool InitAfterFork();

    bool Get(const ui64 Key, TString& Value);
    bool Add(const ui64 Key, TString Value);
    bool Load(ui32& ecount, ui32& edublicat);
    void Clear();
    //size_t Size();

    TSimpleStorageStat GetStat();
};
