#include "tsimplestorage.h"
#include <library/cpp/testing/unittest/registar.h>
Y_UNIT_TEST_SUITE(ShinglerCntSimpStor) {

  Y_UNIT_TEST(SimpStorValue) {
    TKConfig       config;
    TSimpleStorage shinstor;
    bool           res = false;
    TString        value = "";
    TString        test_value = "test_data";

    config.AddParam("storage", "data_filename", "test_file");

    res = shinstor.InitBeforeFork(MSHINGLER, &config, NULL);
    UNIT_ASSERT_EQUAL(res, true);

    shinstor.Add(0x1122334455667788, test_value);
    value = "";
    res = shinstor.Get(0x1122334455667788, value);
    UNIT_ASSERT_EQUAL(res, true);

    res = (value == test_value) ? true : false;
    UNIT_ASSERT_EQUAL(res, true);
  }

  Y_UNIT_TEST(SimpStorClear) {
    TKConfig       config;
    TSimpleStorage shinstor;
    bool           res = false;
    TString        value = "";
    TString        test_value = "test_data";

    config.AddParam("storage", "data_filename", "test_file");

    res = shinstor.InitBeforeFork(MSHINGLER, &config, NULL);
    UNIT_ASSERT_EQUAL(res, true);

    shinstor.Add(0x1122334455667788, test_value);
    shinstor.Clear();
    value = "";
    res = shinstor.Get(0x1122334455667788, value);
    UNIT_ASSERT_EQUAL(res, false);
  }

  Y_UNIT_TEST(SimpStorSize) {
    TKConfig       config;
    TSimpleStorage shinstor;
    bool           res = false;
    TString        value = "";
    TString        test_value = "test_data";
    size_t         count = 0;
    TSimpleStorageStat stat;

    config.AddParam("storage", "data_filename", "test_file");

    res = shinstor.InitBeforeFork(MSHINGLER, &config, NULL);
    UNIT_ASSERT_EQUAL(res, true);

    shinstor.Add(0x1122334455667788, test_value);
    shinstor.Add(0x2233445566778899, test_value);
    shinstor.Add(0x3344556677889900, test_value);
    stat = shinstor.GetStat();
    count = stat.record_count;
    res = (count == 3) ? true : false;
    UNIT_ASSERT_EQUAL(res, true);
  }

}
