#include <library/cpp/config/config.h>
#include <mail/so/libs/talkative_config/config.h>

#include "options.h"

TServerOptions TServerOptions::ReadOptionsFromConfig(const NConfig::TDict& config) {
    TServerOptions options;

    if (auto it = MapFindPtr(config, "port"))
        options.SetPort(NTalkativeConfig::As<ui16>(*it));

    if (auto it = MapFindPtr(config, "host"))
        options.SetHost(NTalkativeConfig::Get<TString>(*it));

    if (auto it = MapFindPtr(config, "threads"))
        options.SetThreads(NTalkativeConfig::As<ui32>(*it));

    if (auto it = MapFindPtr(config, "backlog"))
        options.SetListenBacklog(NTalkativeConfig::As<ui32>(*it));

    if (auto it = MapFindPtr(config, "compression"))
        options.EnableCompression(NTalkativeConfig::As<bool>(*it));

    if (auto it = MapFindPtr(config, "keep_alive"))
        options.EnableKeepAlive(NTalkativeConfig::As<bool>(*it));

    if (auto it = MapFindPtr(config, "max_connections"))
        options.SetMaxConnections(NTalkativeConfig::As<ui32>(*it));

    if (auto it = MapFindPtr(config, "queue"))
        options.SetMaxQueueSize(NTalkativeConfig::As<ui32>(*it));

    if (auto it = MapFindPtr(config, "reject_excess_connections"))
        options.EnableRejectExcessConnections(NTalkativeConfig::As<bool>(*it));

    if (auto it = MapFindPtr(config, "access_log"))
        options.SetAccessLog(NTalkativeConfig::Get<TString>(*it));

    if (auto it = MapFindPtr(config, "error_log"))
        options.SetErrorLog(NTalkativeConfig::Get<TString>(*it));

    if (auto it = MapFindPtr(config, "client_timeout"))
        options.SetClientTimeout(NTalkativeConfig::As<TDuration>(*it));

    return options;
}
