#pragma once

#include <library/cpp/http/server/http_ex.h>

namespace NConfig {
    struct TDict;
}

struct TServerOptions : public THttpServer::TOptions {
    TServerOptions() = default;

    static TServerOptions ReadOptionsFromConfig(const NConfig::TDict& config);

    inline TServerOptions& SetAccessLog(TString log) noexcept {
        AccessLog = std::move(log);
        return *this;
    }
    inline TServerOptions& SetErrorLog(TString log) noexcept {
        ErrorLog = std::move(log);
        return *this;
    }

    TString AccessLog = "cerr";
    TString ErrorLog = "cerr";
};
