#pragma once

#include <util/folder/path.h>
#include <util/system/mutex.h>
#include "handler_server.h"

class TStaticServe : public THandlerFunctor {
public:
    void Reply(THandleContext && handleContext, void* tsr) override;
    void CleanUp();

    explicit TStaticServe(const TFsPath & rootDir);
    ~TStaticServe() override = default;
private:
    const TFsPath rootDir;
    THashMap<TString, TBlob> fileCache;
    TMutex cacheMutex;
};
