#include "tsr.h"

THashMap<TString, THist<TDuration>> TProfiledContext::MakeHist(const THashMap<TString, TVector<TDuration>>& levelsBySignal) {

    THashMap<TString, THist<TDuration>> namedTimeHist;
    for (const auto& stat : GetStats()) {
        auto levelsIt = levelsBySignal.find(stat.GetName());
        if (levelsIt == levelsBySignal.cend())
            continue;

        auto it = namedTimeHist.find(stat.GetName());
        if (it == namedTimeHist.end())
            it = namedTimeHist.emplace(stat.GetName(), THist<TDuration>(levelsIt->second)).first;
        it->second.Add(stat.GetDuration());
    }

    return namedTimeHist;
}

TList<NProf::TNamedItem> TProfiledContext::GetStats() {
    TList<NProf::TNamedItem> allStats;
    TReadGuard g(Mutex);

    const auto previous = Now() - TDuration::Seconds(5);
    for (auto& stats : Resources) {
        allStats.merge(stats.CleanUpAndGet(previous));
    }
    return allStats;
}
