#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/config/config.h>
#include <library/cpp/json/json_writer.h>
#include "handler_server.h"

Y_UNIT_TEST_SUITE(HandlerServer) {
    Y_UNIT_TEST(ReadDefaultOptions) {
        const auto & optionsFromNullConfig = TServerOptions::ReadOptionsFromConfig({});

        NConfig::TConfig emptyConf;
        {
            TStringStream s;
            s << "{}";
            emptyConf = NConfig::TConfig::FromJson(s);
        }

        const auto & optionsFromEmptyConfig = TServerOptions::ReadOptionsFromConfig(emptyConf.Get<NConfig::TDict>());

        const THandlerServer::TOptions defaultOptions;

        UNIT_ASSERT_EQUAL(optionsFromNullConfig.Port, optionsFromEmptyConfig.Port);
        UNIT_ASSERT_EQUAL(optionsFromNullConfig.Host, optionsFromEmptyConfig.Host);
        UNIT_ASSERT_EQUAL(optionsFromNullConfig.nThreads, optionsFromEmptyConfig.nThreads);
        UNIT_ASSERT_EQUAL(optionsFromNullConfig.ListenBacklog, optionsFromEmptyConfig.ListenBacklog);
        UNIT_ASSERT_EQUAL(optionsFromNullConfig.CompressionEnabled, optionsFromEmptyConfig.CompressionEnabled);
        UNIT_ASSERT_EQUAL(optionsFromNullConfig.KeepAliveEnabled, optionsFromEmptyConfig.KeepAliveEnabled);
        UNIT_ASSERT_EQUAL(optionsFromNullConfig.MaxConnections, optionsFromEmptyConfig.MaxConnections);
        UNIT_ASSERT_EQUAL(optionsFromNullConfig.MaxQueueSize, optionsFromEmptyConfig.MaxQueueSize);

        UNIT_ASSERT_EQUAL(optionsFromNullConfig.Port, defaultOptions.Port);
        UNIT_ASSERT_EQUAL(optionsFromNullConfig.Host, defaultOptions.Host);
        UNIT_ASSERT_EQUAL(optionsFromNullConfig.nThreads, defaultOptions.nThreads);
        UNIT_ASSERT_EQUAL(optionsFromNullConfig.ListenBacklog, defaultOptions.ListenBacklog);
        UNIT_ASSERT_EQUAL(optionsFromNullConfig.CompressionEnabled, defaultOptions.CompressionEnabled);
        UNIT_ASSERT_EQUAL(optionsFromNullConfig.KeepAliveEnabled, defaultOptions.KeepAliveEnabled);
        UNIT_ASSERT_EQUAL(optionsFromNullConfig.MaxConnections, defaultOptions.MaxConnections);
        UNIT_ASSERT_EQUAL(optionsFromNullConfig.MaxQueueSize, defaultOptions.MaxQueueSize);
    }

    Y_UNIT_TEST(ReadOptions) {

        TStringStream rawConfig;
        {
            NJson::TJsonWriter writer(&rawConfig, false);
            writer.OpenMap();
            {
                writer.Write("port", 8000);
                writer.Write("host", "somehost.ru");
                writer.Write("threads", 123);
                writer.Write("backlog", 10);
                writer.Write("compression", true);
                writer.Write("keep_alive", false);
                writer.Write("max_connections", 10000000);
                writer.Write("queue", 1047);
            }
            writer.CloseMap();
        }

        const auto & config = NConfig::TConfig::FromStream(rawConfig);

        const auto & options = TServerOptions::ReadOptionsFromConfig(config.Get<NConfig::TDict>());

        UNIT_ASSERT_EQUAL(options.Port, 8000);
        UNIT_ASSERT_EQUAL_C(options.Host, "somehost.ru", options.Host);
        UNIT_ASSERT_EQUAL(options.nThreads, 123);
        UNIT_ASSERT_EQUAL(options.ListenBacklog, 10);
        UNIT_ASSERT_EQUAL(options.CompressionEnabled, true);
        UNIT_ASSERT_EQUAL(options.KeepAliveEnabled, false);
        UNIT_ASSERT_EQUAL(options.MaxConnections, 10000000);
        UNIT_ASSERT_EQUAL(options.MaxQueueSize, 1047);

    }
}
