#pragma once

#include <util/generic/string.h>
#include <util/generic/ptr.h>
#include <util/stream/tempbuf.h>
#include <library/cpp/logger/log.h>
#include <library/cpp/logger/file.h>
#include <library/cpp/logger/stream.h>
#include <mail/so/spamstop/tools/so-common/tlogclass.h>
#include <map>
#include <library/cpp/logger/all.h>


enum TSOLogLevel { SO_ERRORS_ONLY = 0,
                   SO_ERRORS_AND_WARNINGS,
                   SO_LOG_ALL_BUT_DEBUG,
                   SO_LOG_EVERYTHING };
TSOLogLevel Int2TSOLogLevel(int val);

enum TSOLoggers { SO_DAEMON_LOGGER = 0,
                  SO_FILTER_LOGGER,
                  SO_RULES_LOGGER,
                  SO_HTTP_LOGGER,
                  SO_ML_LOGGER,
                  SO_COMPL_LOGGER,
                  SO_USERREP_LOGGER,
                  SO_MAX_LOGGER
                  };

class TSpLogger {
public :
    TSpLogger();
    void SetOpen(bool is_openA) { is_open = is_openA; }

    void Y_PRINTF_FORMAT(3, 4) splog(int priority, const char *msg, ...);
    void Y_PRINTF_FORMAT(2, 3) spprint(const char *msg, ...);
    void spprintlen(const char *msg, size_t len);

    void Openlog(TSOLogLevel log_levelA, const TString& fileName, bool bAddFormatter = true);
    void Closelog();

    void SetSPKLog(TBaseLogClass *extFilterLogA);

    void ReopenLog(){
        utilLoggerPtr.ReopenLog();
    }
    bool IsOpen() { return is_open; };

private:
    constexpr bool CanLog(ELogPriority priority);
    constexpr bool CanLog(int rawPriority);

private:
    bool is_open{};
    bool use_syslog{};
    int log_level{};
    TLog utilLoggerPtr;
    TBaseLogClass *extFilterLog{};
    TFileLogBackend *pFileBackend{};
    TStreamLogBackend *pStreamBackend{};
};

class TSpLoggers {
public:
    ~TSpLoggers();
    void CloseLogs();
    TSpLogger *GetSpLoggerPtr(TSOLoggers loggerID);

    void ReopenLogs() {
        for(auto& logger: loggers)
            logger.ReopenLog();
        ShortLog.ReopenLog();
        KasperskyLogger.ReopenLog();
        JsonMlLog.ReopenLog();
        DeliveryLog.ReopenLog();
    }

    TLog ShortLog;
    TLog KasperskyLogger;
    TLog JsonMlLog;
    TLog DeliveryLog;
private:
    TSpLogger loggers[SO_MAX_LOGGER]{};
};

extern TSpLogger *pDaemonLogger;
extern TSpLogger *pFilterLogger;
extern TSpLogger *pHttpLogger;
