/*
 * TDictRequest.cpp
 *
 *  Created on: 29 янв. 2016 г.
 *      Author: luckybug
 */

#include "TDictRequest.h"

#include <util/stream/printf.h>
#include <util/stream/format.h>

#include <stdlib.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include "functional_clients/RequestBase.h"

namespace DictionaryShingler {
    template <>
    const TString Stat::TimeToString<Stat::TODAY>::str = "Today";
    template <>
    const TString Stat::TimeToString<Stat::YESTERDAY>::str = "Yesterday";
    template <>
    const TString Stat::TimeToString<Stat::HISTORY>::str = "History";

    TString SpamTypeDBId(SpamType st) {
        if (st < 0 || st >= ST_COUNT)
            return "";
        return SpamTypeDBIdrepresentation[st];
    }

    TString SpamTypeToStroka(SpamType value) {
        return (value == ST_UNKNOWN) ? "UNKNOWN" : SpamTypeRepresentation[value];
    }

    TString MailTypeToStroka(MailType value) {
        return MailTypeRepresentation[value];
    }

    template <>
    bool ReqSpamCompatible<RT_PUT>(SpamType st) {
        return st == ST_HAM || st == ST_SPAM;
    }
    template <>
    bool ReqSpamCompatible<RT_ABUSE>(SpamType st) {
        return st == ST_COMPLHAM ||
               st == ST_COMPLSPAM ||
               st == ST_EXPERT_COMPLHAM ||
               st == ST_EXPERT_COMPLSPAM;
    }
    template <>
    bool ReqSpamCompatible<RT_GET>(SpamType /*st*/) {
        return true;
    }
    template <>
    bool ReqSpamCompatible<RT_FISHING>(SpamType st) {
        return st == ST_FISHING;
    }
    template <>
    bool ReqSpamCompatible<RT_VIRUS>(SpamType st) {
        return st == ST_VIRUS;
    }
    template <>
    bool ReqSpamCompatible<RT_FISHING_YAN>(SpamType st) {
        return st == ST_FISHING_YAN;
    }
    template <>
    bool ReqSpamCompatible<RT_HACKED>(SpamType st) {
        return st == ST_HACKED;
    }

    bool Counters::empty() const {
        FOR_DICT_SPAM_TYPE(it) {
            if (fields[it])
                return false;
        }
        return true;
    }

    void Counters::clear() {
        firstTime = 0;
        lastTime = 0;
        FOR_DICT_SPAM_TYPE(it) {
            fields[it] = 0;
        }
    }

    IOutputStream& operator<<(IOutputStream& stream, const Counters& c) {
        stream << c.getFirstTime() << '-' << c.getLastTime();

        FOR_DICT_SPAM_TYPE(it) {
            stream << '-' << c.fields[it];
        }

        return stream;
    }

    TString Counters::ToLog() const {
        TStringStream ss;

        ss << "ft=" << getFirstTime() << ",lt=" << getLastTime() << ",h=" << get<ST_HAM>() << ",s=" << get<ST_SPAM>() << ",ch=" << get<ST_COMPLHAM>() << ",cs=" << get<ST_COMPLSPAM>() << ",v=" << get<ST_VIRUS>() << ",f=" << get<ST_FISHING>() << ",fy=" << get<ST_FISHING_YAN>() << ",hk=" << get<ST_HACKED>() << ",ech=" << get<ST_EXPERT_COMPLHAM>() << ",ecs=" << get<ST_EXPERT_COMPLSPAM>();

        return ss.Str();
    }

    void Counters::merge(const Counters& newCounters) {
        FOR_DICT_SPAM_TYPE(it) {
            fields[it] += newCounters.fields[it];
        }

        if (!firstTime || firstTime > newCounters.firstTime)
            firstTime = newCounters.firstTime;

        if (!lastTime || lastTime < newCounters.lastTime)
            lastTime = newCounters.lastTime;
    }

    bool Counters::incrBySpamType(SpamType st, ui32 val) {
        if (st < 0 || st >= ST_COUNT)
            return false;

        fields[st] += val;

        return true;
    }
    ui32 Counters::getBySpamType(SpamType st) const {
        if (st < 0 || st >= ST_COUNT)
            return 0;

        return fields[st];
    }
    void Counters::setBySpamType(SpamType st, const ui32& val) {
        if (st < 0 || st >= ST_COUNT)
            return;

        fields[st] = val;
    }

    ui32& Counters::setBySpamType(SpamType st) {
        if (st < 0 || st >= ST_COUNT)
            return fields.front();

        return fields[st];
    }

    ui64 Request::GetHash() const {
        ui64 res = 0;
        char sshingle[32] = {};
        const TString temp = UI64ToStroka(shingle) + '_' + UI32ToStroka(mailType);
        calc_strcrc64(temp.c_str(), temp.length(), sshingle);
        sscanf(sshingle, "%lx", &res);
        return res;
    }

    IOutputStream& operator<<(IOutputStream& out, const Request& req) {
        return out << Hex(req.shingle, HF_FULL) << '-' << req.stat.getLanguageRaw() << '-' << int(req.spamtype) << '-' << int(req.mailType);
    }

    bool Request::ParseRequestFromString(const char* str, Request& result) {
        if (!str)
            return false;

        return sscanf(str, "%lx-%lu-%i-%i", &result.shingle, &result.stat.setLanguageRaw(), (int*)&result.spamtype, (int*)&result.SetMailType()) == 4;
    }

    Stat& Request::SetCounters() {
        return stat;
    }

    void Request::SetCounters(const Stat& newStats) {
        stat = newStats;
    }

    const Stat& Request::GetCounters() const {
        return stat;
    }

    ui64 Request::CalcShingle(const TUtf16String& word) {
        ui64 res = 0;
        char sshingle[32] = {};

        if (!word.empty()) {
            calc_strcrc64((char*)word.c_str(), word.length() * sizeof(wchar16), sshingle);
            sscanf(sshingle, "%lx", &res);
        }

        return res;
    }

    TString Request::ToLogShindata() const {
        //TString res = "";
        char buff[256];

        buff[0] = 0x00;
        snprintf(buff, sizeof(buff), "%016lx-%lu word='%s' spamtype=%s mailtype=%s",
                 shingle, stat.getLanguageRaw(), WideToChar(CODES_KOI8, word).c_str(), SpamTypeToStroka(spamtype).c_str(), MailTypeToStroka(mailType).c_str());

        return TString(buff);
    }

    TString Request::ToLog() const {
        return stat.ToLog();
    }

    Request::Request()
        : shingle(0)
        , mailType(MT_INBOX)
        , spamtype(ST_UNKNOWN)
    {
    }
    Request::Request(const TUtf16String& _word, ELanguage language, SpamType spamtype, MailType mailType)
        : shingle(0)
        , word(_word) // (WideToChar(CODES_KOI8, _word))
        , mailType(mailType)
        , spamtype(spamtype)
    {
        stat.setLanguage(language);
        if (!word.empty()) {
            shingle = CalcShingle(word);
        }
    }

} /* namespace DictionaryShingler */
