#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <util/string/cast.h>
#include "tactivityshinglerenv.h"

//*******************************************************************************************************************************
//                                              TActivityShingleRequest
//*******************************************************************************************************************************

TActivityShingleRequest::TActivityShingleRequest(const TString& uid, const TString& suid) {
    TryFromString(uid, m_uid);
    TryFromString(suid, m_uid);
}

bool TActivityShingleRequest::IsValid() const {
    return m_uid != 0;
}

ui32 TActivityShingleRequest::GetSpamReportElapsed() {
    return (time(nullptr) - m_spam_report);
}

ui32 TActivityShingleRequest::GetSettingsElapsed() {
    return (time(nullptr) - m_settings);
}

ui32 TActivityShingleRequest::GetMobileElapsed() {
    return (time(nullptr) - m_mobile);
}

ui32 TActivityShingleRequest::GetYServerImapElapsed() {
    return static_cast<ui32>(time(nullptr) - m_yserver_imap);
}

ui32 TActivityShingleRequest::GetWmiElapsed() {
    return (time(nullptr) - m_wmi);
}

ui32 TActivityShingleRequest::GetMailboxOperElapsed() {
    return (time(nullptr) - m_mailbox_oper);
}

ui32 TActivityShingleRequest::GetYServerPopElapsed() {
    return (time(nullptr) - m_yserver_pop);
}

ui32 TActivityShingleRequest::GetDariaElapsed() {
    return (time(nullptr) - m_daria);
}

ui32 TActivityShingleRequest::GetLizaElapsed() {
    return (time(nullptr) - m_liza);
}

ui32 TActivityShingleRequest::GetTouchElapsed() {
    return (time(nullptr) - m_touch);
}

ui32 TActivityShingleRequest::GetLiteElapsed() {
    return (time(nullptr) - m_lite);
}

ui32 TActivityShingleRequest::GetMobileIOsElapsed() {
    return (time(nullptr) - m_mobile_ios);
}

ui32 TActivityShingleRequest::GetMobileAndroidElapsed() {
    return (time(nullptr) - m_mobile_android);
}

ui32 TActivityShingleRequest::GetTabletIOsElapsed() {
    return (time(nullptr) - m_tablet_ios);
}

ui32 TActivityShingleRequest::GetTabletAndroidElapsed() {
    return (time(nullptr) - m_tablet_android);
}

TString TActivityShingleRequest::ToLog() const {
    char buff[512];

    memset(buff, 0, sizeof(buff));
    snprintf(buff, sizeof(buff), "%lu-%lu empty=%d comp='%u-%u-%u-%u',%u-%u-%u-%u-%u,%u-%u-%u-%u-%u,%u-%u-%u-%u-%u,%u", m_uid, m_suid, (int)Empty(),
             m_complaint_count,
             m_days_with_complaints,
             m_firsttime_complaint,
             m_lasttime_complaint,

             GetSpamReport(), GetSettings(), GetMobile(), GetYServerImap(), GetWmi(), GetMailboxOper(), GetYServerPop(), GetDaria(), GetLiza(), GetTouch(), GetLite(), GetMobileIOs(), GetMobileAndroid(), GetTabletIOs(), GetTabletAndroid(), GetAttribute());

    return TString(buff);
}

bool TActivityShingleRequest::parseFromActJson(const NJson::TJsonValue & json) {
    if(!json.IsMap() || json.GetMap().empty() || !json.Has("module") || !json.Has("last_dt"))
        return true;

    const auto & module = json["module"].GetStringSafe();
    const auto last_dt = static_cast<const ui32>(json["last_dt"].GetUIntegerSafe());

    for(auto & p : {
            std::make_tuple("spam_report", std::ref(m_spam_report)),
            std::make_tuple("settings", std::ref(m_settings)),
            std::make_tuple("mobile", std::ref(m_mobile)),
            std::make_tuple("yserver_imap", std::ref(m_yserver_imap)),
            std::make_tuple("wmi", std::ref(m_wmi)),
            std::make_tuple("mailbox_oper", std::ref(m_mailbox_oper)),
            std::make_tuple("yserver_pop", std::ref(m_yserver_pop)),
            std::make_tuple("daria", std::ref(m_daria)),
            std::make_tuple("liza", std::ref(m_liza)),
            std::make_tuple("touch", std::ref(m_touch)),
            std::make_tuple("lite", std::ref(m_lite)),
            std::make_tuple("mobile_ios", std::ref(m_mobile_ios)),
            std::make_tuple("mobile_android", std::ref(m_mobile_android)),
            std::make_tuple("tablet_ios", std::ref(m_tablet_ios)),
            std::make_tuple("tablet_android", std::ref(m_tablet_android)),
            std::make_tuple("attribute", std::ref(m_attribute)),
            std::make_tuple("hound", std::ref(m_hound)),
    }) {
        if(std::get<0>(p) == module) {
            m_empty = 0;
            std::get<1>(p) = last_dt;
            return true;
        }
    }

    return false;
}

bool TActivityShingleRequest::parseFromComplJson(const NJson::TJsonValue & json) {
    if(!json.IsMap() || json.GetMap().empty())
        return true;

    if(json.Has("days_with_complaints")) {
        m_days_with_complaints = static_cast<ui32>(json["days_with_complaints"].GetUIntegerRobust());
    }
    if(json.Has("firsttime")) {
        m_firsttime_complaint = static_cast<ui32>(json["firsttime"].GetUIntegerRobust());
    }
    if(json.Has("lasttime")) {
        m_lasttime_complaint = static_cast<ui32>(json["lasttime"].GetUIntegerRobust());
    }
    if(json.Has("complaints")) {
        m_complaint_count = static_cast<ui32>(json["complaints"].GetUIntegerRobust());
    }

    return true;
}
