#pragma once

#include <util/generic/string.h>
#include <util/generic/hash.h>
#include <util/generic/hash_set.h>
#include <util/generic/vector.h>
#include <util/system/mutex.h>
#include <util/system/defaults.h>
#include <util/stream/str.h>
#include <library/cpp/string_utils/quote/quote.h>
#include <mail/so/spamstop/tools/so-clients/ktime.h>
#include <library/cpp/json/json_value.h>

enum TActivityRequestType { AT_UNKNOWN,
                            AT_GET };

#define AA_PERSBAYESUID 0x00000001 //personal bayes uid
#define SET_AA_PERSBAYESUID(flag) \
    { (flag) |= AA_PERSBAYESUID; }
#define IS_AA_PERSBAYESUID(flag) ((flag)&AA_PERSBAYESUID)

//*******************************************************************************************************************************
//                                              TActivityShingleRequest
//*******************************************************************************************************************************

class TActivityShingleRequest {
private:
    ui64 m_uid{}, m_suid{};

    ui32 m_complaint_count{};
    ui32 m_lasttime_complaint{}, m_firsttime_complaint{};
    ui32 m_days_with_complaints{};

    ui32 m_empty = 1;
    ui32 m_spam_report{};
    ui32 m_settings{};
    ui32 m_mobile{};
    ui32 m_yserver_imap{};
    ui32 m_wmi{};
    ui32 m_mailbox_oper{};
    ui32 m_yserver_pop{};
    ui32 m_daria{};
    ui32 m_liza{};
    ui32 m_touch{};
    ui32 m_lite{};
    ui32 m_mobile_ios{};
    ui32 m_mobile_android{};
    ui32 m_tablet_ios{};
    ui32 m_tablet_android{};
    ui32 m_attribute{};
    ui32 m_hound{};

public:
    TActivityShingleRequest() = default;

    explicit TActivityShingleRequest(const TString& uid, const TString& suid = "");

    ui64 Uid() const {
        return m_uid;
    }
    ui64 Suid() const {
        return m_suid;
    }
    bool IsValid() const;

    bool Empty() const { return m_empty != 0; }
    ui32 GetSpamReport() const { return m_spam_report; }
    ui32 GetSettings() const { return m_settings; }
    ui32 GetMobile() const { return m_mobile; }
    ui32 GetYServerImap() const { return m_yserver_imap; }
    ui32 GetWmi() const { return m_wmi; }
    ui32 GetMailboxOper() const { return m_mailbox_oper; }
    ui32 GetYServerPop() const { return m_yserver_pop; }
    ui32 GetDaria() const { return m_daria; }
    ui32 GetLiza() const { return m_liza; }
    ui32 GetTouch() const { return m_touch; }
    ui32 GetLite() const { return m_lite; }
    ui32 GetMobileIOs() const { return m_mobile_ios; }
    ui32 GetMobileAndroid() const { return m_mobile_android; }
    ui32 GetTabletIOs() const { return m_tablet_ios; }
    ui32 GetTabletAndroid() const { return m_tablet_android; }
    ui32 GetHound() const { return m_hound; }

    ui32 GetComplaintsCount() const {
        return m_complaint_count;
    }
    kday_t GetLasttimeComplaints() const {
        return kday_t((unsigned long)m_lasttime_complaint);
    }
    kday_t GetFirsttimeComplaints() const {
        return kday_t((unsigned long)m_firsttime_complaint);
    }
    ui32 GetComplaintDaysCount() const {
        return m_days_with_complaints;
    }

    ui32 GetSpamReportElapsed();
    ui32 GetSettingsElapsed();
    ui32 GetMobileElapsed();
    ui32 GetYServerImapElapsed();
    ui32 GetWmiElapsed();
    ui32 GetMailboxOperElapsed();
    ui32 GetYServerPopElapsed();
    ui32 GetDariaElapsed();
    ui32 GetLizaElapsed();
    ui32 GetTouchElapsed();
    ui32 GetLiteElapsed();
    ui32 GetMobileIOsElapsed();
    ui32 GetMobileAndroidElapsed();
    ui32 GetTabletIOsElapsed();
    ui32 GetTabletAndroidElapsed();

    ui32 GetAttribute() const {
        return m_attribute;
    }
    bool IsPersBayesUid() const {
        return IS_AA_PERSBAYESUID(GetAttribute());
    }

    TString ToLog() const;

    bool parseFromActJson(const NJson::TJsonValue & json);
    bool parseFromComplJson(const NJson::TJsonValue & json);
};

typedef TVector<TActivityShingleRequest> TActivityShingleRequestVector;

