#pragma once

#ifndef _CMPL_FLAGS_H_
#define _CMPL_FLAGS_H_

enum CMPLFlags {
    CMPL_MOVED = 0x00000001,
    CMPL_SEEN = 0x00000002,
    CMPL_PERSONAL = 0x00000004,
    CMPL_SKIPPED = 0x00000008,
    CMPL_YTEAM = 0x00000010,
    CMPL_PDD = 0x00000020,
    CMPL_WRONGSPAM = 0x00000040,
    CMPL_WRONGHAM = 0x00000080,
    CMPL_YAFWD = 0x00000100,
    CMPL_WAS = 0x00000200,
    CMPL_FIRSTSNDR = 0x00000400,
    CMPL_FIRSTDMN = 0x00000800,
    CMPL_BAD_CT = 0x00001000,
    CMPL_SEO_ABUSE = 0x00002000
};

#define SET_CMPL_MOVED(flag) \
    { (flag) |= CMPL_MOVED; }
#define SET_CMPL_SEEN(flag) \
    { (flag) |= CMPL_SEEN; }
#define SET_CMPL_PERSONAL(flag) \
    { (flag) |= CMPL_PERSONAL; }
#define SET_CMPL_SKIPPED(flag) \
    { (flag) |= CMPL_SKIPPED; }
#define SET_CMPL_YTEAM(flag) \
    { (flag) |= CMPL_YTEAM; }
#define SET_CMPL_PDD(flag) \
    { (flag) |= CMPL_PDD; }
#define SET_CMPL_WRONGSPAM(flag) \
    { (flag) |= CMPL_WRONGSPAM; }
#define SET_CMPL_WRONGHAM(flag) \
    { (flag) |= CMPL_WRONGHAM; }
#define SET_CMPL_YAFWD(flag) \
    { (flag) |= CMPL_YAFWD; }
#define SET_CMPL_WAS(flag) \
    { (flag) |= CMPL_WAS; }
#define SET_CMPL_FIRSTSNDR(flag) \
    { (flag) |= CMPL_FIRSTSNDR; }
#define SET_CMPL_FIRSTDMN(flag) \
    { (flag) |= CMPL_FIRSTDMN; }
#define SET_CMPL_BAD_CT(flag) \
    { (flag) |= CMPL_BAD_CT; }
#define SET_CMPL_SEO_ABUSE(flag) \
    { (flag) |= CMPL_SEO_ABUSE; }

#define IS_CMPL_MOVED(flag) ((flag)&CMPL_MOVED)
#define IS_CMPL_SEEN(flag) ((flag)&CMPL_SEEN)
#define IS_CMPL_PERSONAL(flag) ((flag)&CMPL_PERSONAL)
#define IS_CMPL_SKIPPED(flag) ((flag)&CMPL_SKIPPED)
#define IS_CMPL_YTEAM(flag) ((flag)&CMPL_YTEAM)
#define IS_CMPL_PDD(flag) ((flag)&CMPL_PDD)
#define IS_CMPL_WRONGSPAM(flag) ((flag)&CMPL_WRONGSPAM)
#define IS_CMPL_WRONGHAM(flag) ((flag)&CMPL_WRONGHAM)
#define IS_CMPL_YAFWD(flag) ((flag)&CMPL_YAFWD)
#define IS_CMPL_WAS(flag) ((flag)&CMPL_WAS)
#define IS_CMPL_FIRSTSNDR(flag) ((flag)&CMPL_FIRSTSNDR)
#define IS_CMPL_FIRSTDMN(flag) ((flag)&CMPL_FIRSTDMN)
#define IS_CMPL_BAD_CT(flag) ((flag)&CMPL_BAD_CT)
#define IS_CMPL_SEO_ABUSE(flag) ((flag)&CMPL_SEO_ABUSE)

#endif
