#pragma once

#ifndef freemail_H
#define freemail_H

#include <util/generic/variant.h>
#include <mail/so/spamstop/tools/so-common/tkipv6.h>

namespace NFreeMail {
    enum ESpamType: ui8 {
        UNKNOWN,
        HAM,
        SPAM,
        MALIC
    };

    struct TRecepientInfo {
        TString address;
        ui32 send{};
        ui32 recieve{};

        TRecepientInfo() = default;
        TRecepientInfo(const TString& address);
        TRecepientInfo(const TString& address, ui32 send, ui32 recv);
    };

    struct THamSpamInfo {
        THamSpamInfo() = default;
        THamSpamInfo(ui32 ham, ui32 spam);

        ui32 ham{};
        ui32 spam{};
    };

    struct TInfo {
        TInfo() = default;
        TInfo(ui32 create, ui32 update, ui32 get, const THamSpamInfo& send, const THamSpamInfo& receive, const THamSpamInfo& complaint,
            const THamSpamInfo& uniq_compluser, ui32 uniq_geozone, ui32 active_days, ui32 max_recipients_count);

        ui32 GetCreateElapsedTime() const;
        ui32 GetUpdateElapsedTime() const;

        ui32 get_time{};
        ui32 create_time{};
        ui32 update_time{};
        THamSpamInfo send;
        THamSpamInfo receive;
        THamSpamInfo complaint;
        THamSpamInfo unique_complaint_user;
        ui32 unique_geo_zone{};
        ui32 active_days{};
        ui32 max_recipients_count{};
    };

    struct TDayCounter {
        TDayCounter();
        TDayCounter(ui32 today, ui32 total);

        ui32 today;
        ui32 total;
    };

    struct TPDDInfo {
        TPDDInfo() = default;
        ui32 GetElapsedTime() const;

        ui32 quota{};
        ui32 karma{};
        ui32 first_time{};
        ui32 mailbox_count{};
        TDayCounter bounce;
        TString admin_uid;
        TString host;
        TKIPv6 ip;
        TString org_id;
        TDeque<TString> domains;
    };

    struct TBounceInfo {
        TBounceInfo();
        TBounceInfo(const TDayCounter& spam, const TDayCounter& unknown, ui32 last_type, ui32 last_date, ui32 get_date);

        ui32 GetElapsedTime() const;

        TDayCounter spam;
        TDayCounter unknown;
        ui32 last_type;
        ui32 last_date;
        ui32 get_date;
    };

    class TEmailInfo {
    public:
        template<bool yandex>
        struct TEmailID : public TString {
            explicit TEmailID(TString id) noexcept : TString(std::move(id)) {}
        };

        using UUID = TEmailID<true>;
        using External = TEmailID<false>;

        TEmailInfo(const UUID& uuid);
        TEmailInfo(const External& email);

        static TEmailInfo Create(const TString& uuid, const TString& external, bool isYandex);

        bool Empty() const;
        bool IsYandex() const;
        ui64 GetUUID() const;
        ui64 GetShingle() const;
        ui64 GetHash() const;

    private:
        std::variant<UUID, External> m_info;
    };
}

IOutputStream& operator<<(IOutputStream& stream, const NFreeMail::THamSpamInfo& value);
IOutputStream& operator<<(IOutputStream& stream, const NFreeMail::TDayCounter& value);

#endif
