#include "freemailhost.h"

#include <mail/so/libs/protect/protect.h>

#include <util/string/cast.h>
#include <util/string/strip.h>
#include <util/string/split.h>
#include <util/stream/str.h>
#include <util/stream/file.h>

static const TTrueConst<THashSet<TString>> hostInfo{
    "km.ru", "freemail.ru", "girlmail.ru", "bossmail.ru", "megabox.ru", "boymail.ru", "safebox.ru",
    "qip.ru", "pochta.ru", "fromru.com", "front.ru", "hotbox.ru", "hotmail.ru", "krovatka.su", "land.ru", "mail15.com", "mail333.com", "newmail.ru", "nightmail.ru", "nm.ru", "pisem.net", "pop3.ru", "rbcmail.ru", "smtp.ru", "5ballov.ru", "aeterna.ru", "ziza.ru", "memori.ru", "photofile.ru", "photoplenka.ru",
    "aol.com",
    "yahoo.com",
    "yandex.ru", "ya.ru", "narod.ru",
    "mail.ru", "inbox.ru", "bk.ru", "list.ru",
    "gmail.com",
    "rambler.ru",
    "hotmail.com", "live.ru", "outlook.com"
};

static TString& ToLower(TString& value) {
    to_lower_k(value);
    return value;
}

bool TFreeMailHosts::IsYahooFrom(const TString& fromdomen) const {
    TVector<TStringBuf> parts;
    Split(fromdomen, ".", parts);
    std::reverse(parts.begin(), parts.end());

    if (parts.size() > 1 && parts[1] == "yahoo")
        return true;

    if (parts.size() > 2 && parts[2] == "yahoo" && (parts[1] == "co" || parts[1] == "com"))
        return true;

    return false;
}

bool TFreeMailHosts::IsFreemailByDomain(const TString& fromdomen) const {
    return hostInfo->contains(fromdomen) || IsYahooFrom(fromdomen);
}

bool TFreeMailHosts::IsExcludeHost(const TStringBuf& email) const {
    TString login = Strip(ToString(email.Before('@')));
    return ToLower(login) == "mailer-daemon";
}

TString TFreeMailHosts::GetDomen(const TStringBuf& from) const {
    TString after = ToString(from.After('@'));
    return ToLower(after);
}

bool TFreeMailHosts::IsFreemailByEmail(const TString& email) const {
    return IsExcludeHost(email)? false : IsFreemailByDomain(GetDomen(email));
}
