#pragma once

#ifndef freemailhost_H
#define freemailhost_H

#include "util/generic/string.h"
#include "util/generic/hash.h"
#include "util/system/mutex.h"

#include <list>
#include <mail/so/spamstop/tools/so-common/tlogclass.h>
#include "ktime.h"
#include "freemail.h"
#include "kshingle.h"

class TFreeMailHosts {
private:
    bool IsExcludeHost(const TStringBuf& email) const;
    TString GetDomen(const TStringBuf& from) const;
    bool IsFreemailByDomain(const TString& fromdomen) const;
    bool IsYahooFrom(const TString& fromdomen) const;
public:
    bool IsFreemailByEmail(const TString& email) const;
};

//******************************************************************************************************************

#endif
