#include "AfClient.h"

namespace NFuncClient {
    TAfClient::TResponse::TResponse(NJson::TJsonValue src)
        : Src(std::move(src)) {
        {
        }
    }
    TAfClient::TResponse TAfClient::Perform(const TRequest& request) const {
        TStringStream data;
        {
            NJsonWriter::TBuf writer(NJsonWriter::HEM_DONT_ESCAPE_HTML, &data);
            writer.WriteJsonValue(&request.Data);
        }

        NCurl::TSimpleArtifacts artifacts;

        if (auto error = TRequestClient::Perform(artifacts, TRequestClient::TRequest{}
            .SetRequest(TStringBuilder{} << "score")
            .SetData(std::move(data.Str())))) {
            ythrow *error;
        }

        return TAfClient::TResponse(NJson::ReadJsonFastTree(artifacts.body.Str()));
    }
} /* namespace NFuncClient */
