#pragma once

#include <library/cpp/enumbitset/enumbitset.h>
#include <library/cpp/json/json_reader.h>
#include "single_request_client.h"

namespace NFuncClient {
    class TAfClient : TRequestClient {
    public:
        class TResponse {
        public:
            explicit TResponse(NJson::TJsonValue src);
            NJson::TJsonValue Src;
        };

        class TRequest {
        public:
            explicit TRequest(NJson::TJsonValue data) noexcept
            : Data(std::move(data)) {

            }
            NJson::TJsonValue Data;
        };

        using TRequestClient::TRequestClient;
        TResponse Perform(const TRequest& request) const;
    };
} /* namespace NFuncClient */
