#pragma once

#include <library/cpp/blackbox2/blackbox2.h>
#include <library/cpp/blackbox2/accessors.h>
#include <library/cpp/blackbox2/src/responseimpl.h>
#include <mail/so/libs/primitives/types.h>
#include "single_request_client.h"
#include <util/generic/variant.h>

namespace NFuncClient {
    class CBB: public TRequestClient {
    public:
        using TRequestClient::TRequestClient;

        struct TRequest : public TString {};
        using TBbKey = std::variant<TLogin, TUid>;

        static TRequest MakeRequest(const TLogin& email, const NBlackbox2::TOptions& options = {}, const TString& sid = "smtp");
        static TRequest MakeRequest(const TUid& uid, const NBlackbox2::TOptions& options = {});
        static TRequest MakeRequest(const TBbKey& key, const NBlackbox2::TOptions& options = {});

        static TMaybe<TString> GetSuidFromBBResponse(const NBlackbox2::TResponse& response);
        static TMaybe<TString> GetCountryFromBBResponse(const NBlackbox2::TResponse& response);
        static TMaybe<TInstant> GetRegDateFromBBResponse(const NBlackbox2::TResponse& response);
        static TMaybe<TString> GetPhoneFromBBResponse(const NBlackbox2::TResponse& response);
        static THashSet<TString> GetPddAliasesFromBBResponse(const NBlackbox2::TResponse& response);

        THolder<NBlackbox2::TResponse> GetUserInfo(const TRequest& request, const TLog& logger);
    };
} /* namespace NFuncClient */

Y_DECLARE_OUT_SPEC(inline, NBlackbox2::TResponse, stream, r) {
    stream << r.Message();
}

Y_DECLARE_OUT_SPEC(inline, NFuncClient::CBB::TRequest, stream, r) {
    stream << TString{r};
}

Y_DECLARE_OUT_SPEC(inline, NBlackbox2::TKarmaInfo, stream, k) {
    const TString& karma = k.Karma();
    const TString& status = k.KarmaStatus();
    const TString& banTime = k.BanTime();
    stream << LabeledOutput(karma, status, banTime);
}

