#include <util/stream/zlib.h>
#include <util/generic/scope.h>
#include <library/cpp/logger/priority.h>
#include <mail/so/spamstop/tools/so-common/so_log.h>
#include "KnnShClient.h"
#include <library/cpp/json/json_reader.h>
#include <util/string/builder.h>
#include <mail/so/libs/syslog/so_log.h>

namespace NFuncClient {
    TMaybe<NSoKNN::TGetNeighborsResponse> TKnn::TNeighborsGetter::Perform(const NSoKNN::TGetNeighborsRequest& request, const TLog& logger) const {
        NCurl::TSimpleArtifacts artifacts;
        {
            TString data = TStringBuilder{} << request;

            if (auto error = TRequestClient::Perform(artifacts, TRequestClient::TRequest{}
                                                                    .SetRequest("knn/neighbors?ver=1")
                                                                    .SetData(std::move(data))
                                                                    .SetHeaders({
                                                                        {"Content-Type: application/json"},
                                                                    }))) {
                logger << (TLOG_ERR) << *error;
                return Nothing();
            }
        }

        try {
            const NJson::TJsonValue value = NJson::ReadJsonTree(&artifacts.body, true);
            auto response = NSoKNN::TGetNeighborsResponse::FromJson(value);
            return {std::move(response)};
        } catch (...) {
            logger << (TLOG_ERR) << artifacts.body.Str() << CurrentExceptionMessageWithBt();
            PushError();
            return Nothing();
        }
    }

    void TKnn::TPointAdder::Perform(const NSoKNN::TAddPointRequest& request, const TLog& logger) const {
        TString data = TStringBuilder{} << request;

        NCurl::TSimpleArtifacts artifacts;
        if (auto error = TRequestClient::Perform(artifacts, TRequestClient::TRequest{}
                                                                .SetRequest("knn/add_point")
                                                                .SetData(std::move(data))
                                                                .SetHeaders({
                                                                    {"Content-Type: application/json"},
                                                                }))) {
            logger << (TLOG_ERR) << *error;
            return;
        }
    }
} // namespace NFuncClient
