#pragma once

#include "single_request_client.h"
#include <mail/so/spamstop/tools/knn_data/point.h>

namespace NFuncClient {
    class TKnn {
        class TNeighborsGetter : TRequestClient {
        public:
            using TRequestClient::TRequestClient;
            TMaybe<NSoKNN::TGetNeighborsResponse> Perform(const NSoKNN::TGetNeighborsRequest& request, const TLog& logger) const;
        };

        class TPointAdder : TRequestClient {
        public:
            using TRequestClient::TRequestClient;
            void Perform(const NSoKNN::TAddPointRequest& request, const TLog& logger) const;
        };

    public:
        explicit TKnn(const TRequestClient::TArgs& args) noexcept
            : Updater(PrepareForPut(args))
            , Getter(PrepareForGet(args)) {
        }

        const TPointAdder Updater;
        const TNeighborsGetter Getter;

    private:
        static TRequestClient::TArgs PrepareForGet(TRequestClient::TArgs args) {
            if (args.Config.YasmPrefix)
                args.Config.YasmPrefix += "_NEIGHBORS";
            return args;
        }
        static TRequestClient::TArgs PrepareForPut(TRequestClient::TArgs args) {
            if (args.Config.YasmPrefix)
                args.Config.YasmPrefix += "_ADD_POINT";
            return args;
        }
    };
} // namespace NFuncClient
