#include <util/string/builder.h>
#include <mail/so/spamstop/tools/so-common/so_log.h>
#include <util/stream/zlib.h>
#include <util/generic/scope.h>
#include <mail/so/libs/syslog/so_log.h>
#include "LSAShClient.h"

namespace NFuncClient {
    NLSA::TResponseData TLSA::Perform(const NLSA::TRequestData& request, bool testing) const {
        NCurl::TSimpleArtifacts artifacts;
        {
            TString data = TStringBuilder{} << request;

            if (auto error = TRequestClient::Perform(artifacts, TRequestClient::TRequest{}
                                                                    .SetRequest(TStringBuilder{} << "lsa_get_top_themes" << (testing ? TStringBuf("?from-testing=true") : TStringBuf{}))
                                                                    .SetData(std::move(data))
                                                                    .SetHeaders({
                                                                        {"Content-Type: application/json"},
                                                                    }))) {
                ythrow *error;
            }
        }

        try {
            return NLSA::TResponseData::FromJson(artifacts.body.Str());
        } catch (...) {
            PushError();
            std::rethrow_exception(std::current_exception());
        }
    }
} // namespace NFuncClient
