#include <mail/so/spamstop/tools/so-common/so_log.h>
#include <util/generic/scope.h>
#include <util/string/builder.h>
#include <mail/so/spamstop/tools/so-common/shconn.h>
#include "LogoutUserClient.h"

namespace NFuncClient {
    TString TLogoutUser::Perform(const TString& sUID) const {
        NCurl::TSimpleArtifacts artifacts;
        {
            const TParametrsList plist = {
                {"uid", sUID},
                {"priority", "10"},
                {"reason", "auto logout by SO"}};

            if (auto error = TRequestClient::Perform(artifacts, TRequestClient::TRequest{}
                                                                    .SetRequest("1/users/?consumer=spdaemon")
                                                                    .SetData(MakeCGIString(plist))
                                                                    .SetHeaders({{"Content-Type: application/x-www-form-urlencoded"}}))) {
                return {};
            }
        }
        if (!artifacts.body.Str().Contains(R"("status": "ok")")) {
            PushError();
        }
        return std::move(artifacts.body.Str());
    }

} /* namespace NFuncClient */
