
#include <util/string/builder.h>
#include <mail/so/spamstop/tools/so-common/shconn.h>
#include <mail/so/libs/syslog/so_log.h>
#include "PassportClient.h"

namespace NFuncClient {
    static const constexpr TStringBuf CONSUMER = "spdaemon"sv;
    void TSetKarma::Perform(const TLog& logger, const TString& uid, const TString& prefix) const {
        NCurl::TSimpleArtifacts artifacts;
        {
            const TParametrsList plist = {
                {"admin_name", "sp-daemon"},
                {"comment", "karma clean by SO"},
                {"prefix", prefix},
            };

            if (auto error = TRequestClient::Perform(artifacts,
                                                     TRequest{}
                                                         .SetRequest(TStringBuilder{} << "1/account/" << uid << "/karma/?consumer=" << CONSUMER)
                                                         .SetData(MakeCGIString(plist)))) {
                return;
            }
        }

        const bool result = artifacts.body.Str().Contains(R"("status": "ok")");

        if (!result) {
            logger << (TLOG_WARNING) << "CSetKarma::CleanUserKarma is not ok: " << artifacts.body.Str();
            PushError();
        }
    }

    void TLogout::Perform(const TLog& logger, const TString& uid, const TString& qid) const {
        if (!uid) {
            logger << (TLOG_WARNING) << "Empty UID in Logout";
            PushError();
            return;
        }

        NCurl::TSimpleArtifacts artifacts;
        {
            const TParametrsList plist = {
                {"comment", TStringBuilder{} << "logout by SO; QID: " << qid},
                {"admin_name", "sp-daemon"},
                {"global_logout", "1"},
                {"is_changing_required", "1"},
                {"max_change_frequency_in_days", "4"},
            };

            if (auto error = TRequestClient::Perform(artifacts,
                                                     TRequest{}
                                                         .SetRequest(TStringBuilder{} << "/2/account/" << uid << "/password_options/?consumer=" << CONSUMER)
                                                         .SetData(MakeCGIString(plist)))) {
                logger << TLOG_ERR << "TPassportClient::Logout: " << error;
                return;
            }
        }

        const bool result = artifacts.body.Str().Contains(R"("status": "ok")");

        if (!result) {
            logger << (TLOG_WARNING) << "TPassportClient::Logout is not ok: " << artifacts.body.Str();
            PushError();
        }
    }
} /* namespace NFuncClient */
