#pragma once

#include "single_request_client.h"

namespace NFuncClient {

    class TSetKarma: TRequestClient {
    public:
        using TRequestClient::TRequestClient;
        void Perform(const TLog& logger, const TString& uid, const TString& sPrefix) const;
    };

    class TLogout: TRequestClient {
    public:
        using TRequestClient::TRequestClient;
        /// https://wiki.yandex-team.ru/passport/api/bundle/changeaccount/?from=%2Fpassport%2Fpython%2Fapi%2Fbundle%2Fchangeaccount%2F#izmenitnastrojjkiparoljaprinuditelnajasmenaotzyvavtorizaciiit.p
        void Perform(const TLog& logger, const TString& uid, const TString& qid) const;
    };

    class TPassportClient {
    public:
        explicit TPassportClient(const TRequestClient::TArgs& args) noexcept
            : SetKarma(args.PopulateWithYasm("_SET_KARMA"))
            , Logout(args.PopulateWithYasm("_LOGOUT")) {
        }

        TSetKarma SetKarma;
        TLogout Logout;
    };
} /* namespace NFuncClient */
