#pragma once

#include <util/generic/yexception.h>
#include <util/generic/map.h>
#include <util/stream/str.h>

namespace NFuncClient {
    class CRequestBase {
    public:
        virtual TString getLogCode() const = 0;
        virtual TString getIdent() const = 0;
        virtual bool empty() const = 0;
        virtual TString getRequestData() const = 0;
        virtual TString toLog() const = 0;

        virtual TString getQueryParams() const {
            return "";
        };

        virtual ~CRequestBase() = default;
    };

    class CPutRequest: public CRequestBase {
    public:
        ~CPutRequest() override = default;
    };
    class CGetRequest: public CRequestBase {
    public:
        virtual void parseFromString(const TString& s) = 0;
        virtual bool needDecompress() const {
            return true;
        }

        ~CGetRequest() override = default;
    };

} /* namespace NFuncClient */
