#pragma once

#include "single_request_client.h"

namespace NFuncClient {
    class TSherlock : TRequestClient {
    public:
        using TRequestClient::TRequestClient;

        struct TResponse {
            struct THashPrinter {
                friend TResponse;
                friend IOutputStream& operator<<(IOutputStream& stream, const THashPrinter& printer);

            private:
                explicit THashPrinter(const TResponse& master) noexcept
                    : Master(master) {
                }
                const TResponse& Master;
            };

            const auto& GetHashes() const {
                return Hashes;
            }

            const auto& GetStableSign() const {
                return StableSign;
            }

            THashPrinter PrintHashes() const {
                return THashPrinter(*this);
            }

            NJson::TJsonValue HashesAsJson() const;

            static TResponse Parse(const NJson::TJsonValue& js);

        private:
            TDeque<TVector<TString>> Hashes;
            TDeque<TString> Urls;
            TMaybe<ui64> StableSign;
        };

        struct TRequest {
            const TString& GetHtml() const;
            const TString& GetQueueId() const;
            const TString& GetFrom() const;
            const TString& GetSubject() const;
            const TVector<TString>& GetUids() const;
            const TString& GetService() const;

            TRequest(
                TString html,
                TString queueId,
                TString from,
                TString subject,
                TString service,
                TVector<TString> uids) noexcept;

        private:
            TString Html, QueueId, From, Subject, Service;
            TVector<TString> Uids;
        };

        TMaybe<TResponse> Perform(const TRequest& request, const TLog& logger);
    };
} // namespace NFuncClient
