#include <util/generic/scope.h>
#include <mail/so/spamstop/tools/so-common/so_log.h>
#include <mail/so/libs/syslog/so_log.h>
#include "ShingleShClient.h"
#include <mail/so/spamstop/tools/so-clients/SperrorHolder.h>

namespace NFuncClient {
    // true - все ок, уников нет, false - уники есть
    static bool CheckShinglerUniq(TShingleStatList& shlist, int& delete_shingles_count, TString& all_shingles, TString& dublicat_shingles) {
        typedef THashMap<ui64, int> TUniqHash;
        typedef TUniqHash::iterator TUniqHashIt;
        bool res = true;
        TUniqHash uniq_hash;
        TUniqHashIt uit;
        TShingleStatListIt it;
        TString st = "";
        ui64 shingle = 0;

        all_shingles = "";
        dublicat_shingles = "";
        delete_shingles_count = 0;

        it = shlist.begin();
        while (it != shlist.end()) {
            if (all_shingles.empty())
                all_shingles = all_shingles + (*it).ShingleAndTypeS();
            else
                all_shingles = all_shingles + ", " + (*it).ShingleAndTypeS();

            if ((*it).Shingle() != 0) {
                st = (*it).ShingleStr() + "-" + IntToStroka((*it).Type()) + "=" + (*it).ShingleStr_uniq() + "-" + IntToStroka((*it).Type_uniq());
                shingle = GetShingle(st);
                if (shingle != 0) {
                    uit = uniq_hash.find(shingle);
                    if (uit != uniq_hash.end()) {
                        if (dublicat_shingles.empty())
                            dublicat_shingles = dublicat_shingles + (*it).ShingleAndTypeS();
                        else
                            dublicat_shingles = dublicat_shingles + ", " + (*it).ShingleAndTypeS();

                        shlist.erase(it++);
                        delete_shingles_count = IncMax32(delete_shingles_count, 1);

                        res = false;
                        continue;

                    } else {
                        uniq_hash[shingle] = 0;
                    }
                }
            }

            ++it;
        }

        return res;
    }

    bool TCountShingler::TGetter::Perform(TShingleStatList& shlist, const TLog& logger) const {
        TString rident = "shinrqst?";
        TString request = rident;
        TString trequest_sh = "";
        TString trequest_st = "";
        TShingleStatListIt shit;
        TShingleStatListIt it1, it2;
        TString s = "";
        TShingleStatList shlist_temp;
        ui32 unknown_formt_count = 0;
        bool exists = false;
        ui64 shin1 = 0;
        ui64 shin2 = 0;
        ui64 uniqshin1 = 0;
        ui64 uniqshin2 = 0;
        int type1 = 0;
        int type2 = 0;
        int uniqtype1 = 0;
        int uniqtype2 = 0;
        TShingleStat::TShingleForm sf1;
        TShingleStat::TShingleForm sf2;
        int delete_shingles_count = 0;
        TString all_shingles = "";
        TString dublicat_shingles = "";

        //обеспечиваем уникальность шинглов в списке
        if (!CheckShinglerUniq(shlist, delete_shingles_count, all_shingles, dublicat_shingles)) {
            logger << (TLOG_ERR) << "NG: Bad uniq shingles in request, delete " << delete_shingles_count << " shingles (" << dublicat_shingles << ") from all " << all_shingles;
        }
        //sh shingles
        unknown_formt_count = 0;
        trequest_sh = "";
        trequest_st = "";
        shit = shlist.begin();
        while (shit != shlist.end()) {
            if ((*shit).ShingleForm() == TShingleStat::TSHSHINGLE) {
                s = (*shit).GetRequest();
                if (!s.empty())
                    trequest_sh = trequest_sh + s + "&";

            } else if ((*shit).ShingleForm() == TShingleStat::TSHSTORAGE) {
                s = (*shit).GetRequest();
                if (!s.empty())
                    trequest_st = trequest_st + s + "&";

            } else
                unknown_formt_count++;

            ++shit;
        }
        if (!trequest_sh.empty())
            request = request + "shget=" + trequest_sh;
        if (!trequest_st.empty())
            request = request + "stget=" + trequest_st;

        if (unknown_formt_count != 0) {
            return false;
        }


        if (request == rident) {
            return false;
        }

        NCurl::TSimpleArtifacts answer;
        {
            if (auto error = TRequestClient::Perform(
                answer,
                    TRequestClient::TRequest{}
                        .SetRequest(std::move(request)))) {
                logger << (TLOG_ERR) << "TCountShinglerGetter:" << *error;
                return false;
            }
        }

        bool foundany = false;
        shlist_temp.clear();
        if (!NShingleStatParser::ParseShinglesData(answer.body.Str(), shlist_temp)) {
            return false;
        }

        it1 = shlist_temp.begin();
        while (it1 != shlist_temp.end()) {
            shin1 = (*it1).Shingle();
            type1 = (*it1).Type();
            uniqshin1 = (*it1).Shingle_uniq();
            uniqtype1 = (*it1).Type_uniq();
            sf1 = (*it1).ShingleForm();

            //ищем в результирующем списке, чтобы записать данные с сервера
            exists = false;
            it2 = shlist.begin();
            while (it2 != shlist.end()) {
                shin2 = (*it2).Shingle();
                type2 = (*it2).Type();
                uniqshin2 = (*it2).Shingle_uniq();
                uniqtype2 = (*it2).Type_uniq();
                sf2 = (*it2).ShingleForm();

                if (((*it1).Shingle() == (*it2).Shingle()) && ((*it1).ShingleForm() == (*it2).ShingleForm())) {
                    if ((*it1).ShingleForm() == TShingleStat::TSHSTORAGE) {
                        (*it2) = (*it1);
                        exists = true;
                        //break;

                    } else if (((*it1).ShingleForm() == TShingleStat::TSHSHINGLE) && ((*it1).Type() == (*it2).Type()) && ((*it1).Shingle_uniq() == (*it2).Shingle_uniq()) && ((*it1).Type_uniq() == (*it2).Type_uniq())) {
                        (*it2) = (*it1);
                        exists = true;
                        //break;
                    }
                }

                it2++;
            }
            //не нашли, прерываем
            if (exists == true) {
                foundany = true;
                //break;
            }

            ++it1;
        }
        return foundany;
    }

    bool TCountShingler::TUpdater::Perform(TShingleStatList& shlist, TShingleCount spamtype, TPersType pers, const TLog& logger) const {
        TString rident = "shinrqst?";
        TString request = rident;
        TString trequest = "";
        TShingleStatListIt shit;
        TShingleStatListIt it1, it2;
        TString s = "";
        TShingleStatList shlist_temp;
        ui32 unknown_formt_count = 0;
        TShingleStat v1;
        TShingleStat v2;
        int delete_shingles_count = 0;
        TString all_shingles = "";
        TString dublicat_shingles = "";

        //обеспечиваем уникальность шинглов в списке
        if (!CheckShinglerUniq(shlist, delete_shingles_count, all_shingles, dublicat_shingles)) {
            logger << (TLOG_ERR) << "NG: Bad uniq shingles in request, delete " << delete_shingles_count << " shingles (" << dublicat_shingles << ") from all " << all_shingles;
        }

        //sh shingles
        unknown_formt_count = 0;
        trequest = "";
        shit = shlist.begin();
        while (shit != shlist.end()) {
            if ((*shit).ShingleForm() == TShingleStat::TSHSHINGLE) {
                s = (*shit).PutRequest((*shit).GetCount(), spamtype, pers);
                if (!s.empty())
                    trequest = trequest + s + "&";

            } else if ((*shit).ShingleForm() == TShingleStat::TSHSTORAGE) {
            } else
                unknown_formt_count++;

            ++shit;
        }
        if (!trequest.empty())
            request = request + "shput=" + trequest;

        if (unknown_formt_count != 0) {
            PushError();
            return false;
        }

        if (request == rident) {
            PushError();
            return false;
        }

        if (auto error = TRequestClient::Perform(
            TRequestClient::TRequest{}
                .SetRequest(std::move(request)))) {
            logger << (TLOG_ERR) << "TCountShinglerUpdater:" << *error;
            return false;
        }

        return true;

    }
} /* namespace NFuncClient */
