#pragma once

#include <mail/so/spamstop/tools/so-clients/kshingle.h>
#include <mail/so/spamstop/tools/so-clients/tshinglerenv.h>
#include "single_request_client.h"

namespace NFuncClient {
    class TCountShingler {
        class TGetter : TRequestClient {
        public:
            using TRequestClient::TRequestClient;
            bool Perform(TShingleStatList& shlist, const TLog& logger) const;
        };
        class TUpdater : TRequestClient {
        public:
            using TRequestClient::TRequestClient;
            bool Perform(TShingleStatList& shlist, TShingleCount spamtype, TPersType pers, const TLog& logger) const;
        };

    public:
        explicit TCountShingler(const TRequestClient::TArgs& args)
            : Updater(args.PopulateWithYasm("_NP"))
            , Getter(args.PopulateWithYasm("_NG")) {
        }

        bool GetNs(TShingleStatList& shlist, const TLog& logger) const {
            return Getter.Perform(shlist, logger);
        }
        bool PutNs(TShingleStatList& shlist, TShingleCount spamtype, TPersType pers, const TLog& logger) const {
            return Updater.Perform(shlist, spamtype, pers, logger);
        }

    private:
        const TUpdater Updater;
        const TGetter Getter;
    };
} /* namespace NFuncClient */
