#include <util/generic/scope.h>
#include <mail/so/spamstop/tools/so-common/so_log.h>
#include <mail/so/spamstop/tools/so-common/shconn.h>
#include <mail/so/libs/syslog/so_log.h>
#include "SpamStatShClient.h"

namespace NFuncClient {
    bool TSpamStat::Perform(const TParsedDlvLogData& data, TResData& resdata, TRuleStatList& rlist, ui32 sendtorbl, const TLog& logger) const {
        TRules Rules;
        TSzStruct szobj;

        rlist.clear();
        Rules.clear();
        resdata = {};

        if (!CheckMailSPST(data, Rules, szobj, sendtorbl, logger)) {
            return false;
        }
        ParseResponce(Rules, resdata, rlist);

        return true;
    }

    bool TSpamStat::CheckMailSPST(const TParsedDlvLogData& data, TRules& Rules, TSzStruct& szobj, ui32 sendtorbl, const TLog& logger) const {
        TParsedDlvLogDataEx odata;
        TString difftext = "";

        Rules.clear();

        odata.data = data;
        if (odata.PackCompress()) {
            return CheckMailSPSTA(odata, Rules, szobj, sendtorbl, logger);
        } else {
            logger << (TLOG_ERR) << "CheckMailSPST: Bad serialize data";
            return false;
        }
    }

    bool TSpamStat::CheckMailSPSTA(TParsedDlvLogDataEx& odata, TRules& Rules, TSzStruct& szobj, ui32 sendtorbl, const TLog& logger) const {
        double SpamWeight = 0;
        ui32 ResponceSize = 0;
        TString rqst_mailsize_s = "";

        Rules.clear();

        const TStringBuf data{odata.GetPackCompressData(), odata.GetPackCompressDataSize()};

        auto m_RequestMailSize = data.size();
        rqst_mailsize_s = IntToStroka(m_RequestMailSize) + szobj.PrintCalc(m_RequestMailSize);
        if ((data == nullptr) || (data.size() == 0)) {
            logger << (TLOG_ERR) << "Bad serialize data";
            return false;
        }

        TParametrsList plist;
        {
            TString dlv_ip = odata.data.m_exportdata.ipaddresses.sourceip.m_ip.toStroka();
            if (!dlv_ip.empty()) {
                CGIEscape(dlv_ip);
                plist.emplace_back("ip", std::move(dlv_ip));
            }
        }

        {
            TString sendtorbl_s = UI32ToStroka(sendtorbl);

            if (!sendtorbl_s.empty())
                plist.emplace_back("sendtorbl", std::move(sendtorbl_s));
        }

        plist.emplace_back("mail", TString{data});

        NCurl::TSimpleArtifacts artifacts;
        if (auto error = TRequestClient::Perform(
                artifacts,
                TRequestClient::TRequest{}
                    .SetRequest("checs")
                    .SetData(MakeCGIString(plist))
                    .SetHeaders({{"Content-Type: application/x-www-form-urlencoded"}}))) {
            logger << (TLOG_ERR) << "CheckMailSPSTA:" << *error << ' ' << artifacts.body.Str();
            return false;
        }

        ResponceSize = artifacts.body.Size();
        if (!GetResults2(Rules, SpamWeight, artifacts.body.Str())) {
            PushError();
            logger << (TLOG_ERR) << "Bad response(%u)\tsz=%s";
            return false;
        }

        return true;
    }

    void TSpamStat::ParseResponce(TRules& Rules, TResData& resdata, TRuleStatList& rlist) const {
        TRules::iterator it;
        const char *pb = nullptr, *pe = nullptr;
        ui32 ban = 0;
        ui32 save = 0;
        bool ban_part = false, dob_part = false, rule_part = false, trap_part = false;
        ui32 cDaysRej = 0;
        ui32 cDaysNoRej = 0;
        ui32 tSpam = 0;
        ui32 tHam = 0;
        ui32 tMalicSpam = 0;
        ui32 ySpam = 0;
        ui32 yHam = 0;
        ui32 yMalicSpam = 0;
        ui32 hSpam = 0;
        ui32 hHam = 0;
        ui32 hMalicSpam = 0;
        ui32 isforward = 0;
        ui32 age = 0;
        TString banb = "begin", bane = "end";
        TString dobb = "<ext>", dobe = "</ext>";
        TString rulsb = "<ruls>", rulse = "</ruls>";
        TString trapb = "<trapremain>", trape = "</trapremain>";
        TString trapdata_s = "";
        TString tstr = "";

        it = Rules.begin();
        while (it != Rules.end()) {
            tstr = (*it);
            if (!(*it).empty()) {
                if (!ban_part) //ban part
                {
                    pb = strstr((*it).c_str(), banb.c_str());
                    pe = strstr((*it).c_str(), bane.c_str());
                    if ((pb != nullptr) && (pe != nullptr) && (pe > pb)) {
                        if (sscanf((*it).c_str(), "begin ban %u save %u end", &ban, &save) == 2) {
                            resdata.ban = ban;
                            resdata.save = save;
                            ban_part = true;
                            ++it;
                            continue;
                        }
                    }
                }

                if (!dob_part) //dob part
                {
                    pb = strstr((*it).c_str(), dobb.c_str());
                    pe = strstr((*it).c_str(), dobe.c_str());
                    if ((pb != nullptr) && (pe != nullptr) && (pe > pb)) {
                        if (sscanf((*it).c_str() + dobb.length(), "dr %u dnr %u ts %u th %u tm %u ys %u yh %u ym %u hs %u hh %u hm %u frwd %u age %u", &cDaysRej, &cDaysNoRej, &tSpam, &tHam, &tMalicSpam, &ySpam, &yHam, &yMalicSpam, &hSpam, &hHam, &hMalicSpam, &isforward, &age) == 13) {
                            resdata.cDaysRej = cDaysRej;
                            resdata.cDaysNoRej = cDaysNoRej;
                            resdata.tSpam = tSpam;
                            resdata.tHam = tHam;
                            resdata.tMalicSpam = tMalicSpam;
                            resdata.ySpam = ySpam;
                            resdata.yHam = yHam;
                            resdata.yMalicSpam = yMalicSpam;
                            resdata.hSpam = hSpam;
                            resdata.hHam = hHam;
                            resdata.hMalicSpam = hMalicSpam;
                            resdata.isforward = isforward;
                            resdata.age = age;
                            dob_part = true;
                            ++it;
                            continue;
                        }
                    }
                }

                if (!rule_part) {
                    pb = strstr((*it).c_str(), rulsb.c_str());
                    pe = strstr((*it).c_str(), rulse.c_str());
                    if ((pb != nullptr) && (pe != nullptr) && (pe > pb)) {
                        GetListRule2((*it).c_str() + rulsb.length(), (*it).length() - rulsb.length() - rulse.length(), rlist);
                        rule_part = true;
                        ++it;
                        continue;
                    }
                }

                if (!trap_part) {
                    pb = strstr((*it).c_str(), trapb.c_str());
                    pe = strstr((*it).c_str(), trape.c_str());
                    if ((pb != nullptr) && (pe != nullptr) && (pe > pb)) {
                        trapdata_s = Trim(TString((*it).c_str() + trapb.length(), (*it).length() - trapb.length() - trape.length()));
                        trap_part = true;
                        ++it;
                        continue;
                    }
                }
            }

            ++it;
        }
    }
} /* namespace NFuncClient */
