#include "StatLogClient.h"
#include <mail/so/spamstop/tools/so-common/sobase64.h>
#include <mail/so/spamstop/tools/so-common/so_log.h>
#include <library/cpp/cgiparam/cgiparam.h>
#include <util/string/builder.h>
#include <util/string/join.h>
#include <mail/so/libs/syslog/so_log.h>

namespace NFuncClient {
    TString CStatLogClient::TRequest::ToCGI() && {
        if(RcptsUids.size() > 200)
            RcptsUids.resize(200);

        return TCgiParameters({
             {"ts", ToString(MessTime.TimeT())},
             {"fromaddr", std::move(FromAddr)},
             {"msgid", std::move(MessageId)},
             {"source_ip", std::move(SourceIp)},
             {"queueid", std::move(QueueId)},
             {"locl", std::move(LocL)},
             {"mx", std::move(Mx)},
             {"suid", std::move(Suid)},
             {"uid", std::move(Uid)},
             {"code", ToString(Code)},
             {"rcpts_uids", JoinSeq(",", RcptsUids)},
        }).Print();
    }

    bool CStatLogClient::SendDlvLog(TRequest request, TStringBuf log, const TLog& logger) const {
        if(!log) {
            logger << (TLOG_ERR) << "CheckMailCompress: empty mail";
            PushError();
            return false;
        }

        TString compressed, err;
        if(!CompressAndBase64Url(log.data(), log.size(), compressed, err)) {
            logger << (TLOG_ERR) << "CheckMailCompress: " << err;
            PushError();
            return false;
        }

        if(auto error = Perform(TRequestClient::TRequest{}
                                            .SetRequest(TStringBuilder{} << "check?" << std::move(request).ToCGI())
                                            .SetData(std::move(compressed)))) {
            logger << (TLOG_ERR) << "CheckMailCompress: send error: " << error;
            return false;
        }

        return true;
    }
} // namespace NFuncClient
