#include "StatUtil.h"

#include <util/generic/vector.h>
#include <util/string/strip.h>
#include <mail/so/spamstop/tools/so-common/sputil.h>

namespace NFuncClient {

    TString TResData::Print() const {
        TString res = "";
        char tbuff[256];

        memset(tbuff, 0, sizeof(tbuff));
        snprintf(tbuff, sizeof(tbuff) - 1, "ban=%u save=%u dr=%u dnr=%u ts=%u th=%u tm=%u ys=%u yh=%u ym=%u hs=%u hh=%u hm=%u frwd=%u age=%u", ban, save, cDaysRej, cDaysNoRej, tSpam, tHam, tMalicSpam, ySpam, yHam, yMalicSpam, hSpam, hHam, hMalicSpam, isforward, age);

        res = TString(tbuff);
        return res;
    }
    TRuleStat::TRuleStat(const TString& rulenameA, ui32 counthamA, ui32 countspamA, ui32 countmalicA) {
        rulename = rulenameA;
        count_ham = counthamA;
        count_spam = countspamA;
        count_malic = countmalicA;
    }

    TString TSzStruct::PrintCalc(ui32 newsize) const {
        TString res = "";

        if ((m_calc) && (m_source_size > 0)) {
            float oldsize_prcnt = 0;
            float newsize_prcnt = 0;
            char tbuff[64];

            memset(tbuff, 0, sizeof(tbuff));
            oldsize_prcnt = (float)m_old_pack_size / (float)m_source_size;
            newsize_prcnt = (float)newsize / (float)m_source_size;
            snprintf(tbuff, sizeof(tbuff) - 1, "(old=%0.2f,new=%0.2f)", oldsize_prcnt, newsize_prcnt);
            res = TString(tbuff);
        }

        return res;
    }

    ui32 GetStr(const char* source, ui32 source_size, char* destination, ui32 destination_size) {
        long pos = -1;
        ui32 res = 0;
        ui8 dob = 0;

        for (ui32 i = 0; i < source_size; i++) {
            if ((source[i] == 0x0D) && ((i + 1) < source_size) && (source[i + 1] == 0x0A)) {
                pos = i;
                dob = 1;
                break;
            }
            if (source[i] == 0x0A) {
                pos = i;
                dob = 0;
                break;
            }
        }
        res = pos + 1 + dob;
        if (res == 0)
            res = source_size;
        if (res > 0) {
            memset(destination, 0, destination_size);
            if (res <= destination_size) {
                memcpy(destination, source, res);
            } else {
                memcpy(destination, source, destination_size);
            }
        }
        return res;
    }
    bool GetResults2(TRules& Rules, double& /*SpamWeight*/, TStringBuf buff) {
        ui32 m_buff_pos = 0;
        ui32 strlength = 0;
        //char   strdata[256];

        char m_res_strdata[65500];
        while (m_buff_pos < buff.size()) {
            strlength = GetStr(buff.data() + m_buff_pos, buff.size() - m_buff_pos, m_res_strdata, sizeof(m_res_strdata) - 1);
            if (strlength > 0) {
                m_buff_pos += strlength;
                Rules.emplace_back(StripString(TStringBuf(m_res_strdata)));
            }
        }

        return true;
    }

    void GetListRule2(const char* str, ui32 strsize, TRuleStatList& rlist) {
        const char* p = nullptr;
        const char* pred = nullptr;
        char array1[64];
        char array2[64];
        TString s = "";
        ui32 count_ham = 0;
        ui32 count_spam = 0;
        ui32 count_malic = 0;

        rlist.clear();
        p = nullptr;
        pred = str;
        p = strstr(pred, ",");
        while ((p != nullptr) && (p < (str + strsize))) {
            memset(array1, 0, sizeof(array1));
            memset(array2, 0, sizeof(array2));
            memcpy(array1, pred, p - pred);
            if (sscanf(array1, " %63s %u %u %u ", array2, &count_ham, &count_spam, &count_malic) == 4)
                rlist.push_back(TRuleStat(TString(array2), count_ham, count_spam, count_malic));

            pred = p + 1;
            if (pred != nullptr)
                p = strstr(pred, ",");
            else
                p = nullptr;
        }
    }
}
