#pragma once
#include <util/generic/string.h>
#include <util/generic/strbuf.h>
#include <util/generic/list.h>

namespace NFuncClient {

    struct TResData {
        int ban{};         //1 - �������� ip, 2 - ������� ����� ������, 7 - ������ ���� �������� � ����, 8 - ������ ���� �������� � ���� ???
        bool save{};       //��������� ������ (������������� ��� ban3mail, ��������� ������ 3 ������)
        ui32 cDaysRej{};   //(history.cDaysRej) - ������� ���� ���������
        ui32 cDaysNoRej{}; //(history.cDaysNoRej) - ������� ���� ��������� ��� ���������
        ui32 tSpam{};      //(today.ctSpam) - today � ��� ����� � malicious
        ui32 tHam{};       //(today.ctHam) - today dlv or ham
        ui32 tMalicSpam{}; //(today.ctMalicSpam) - today malicious spam
        ui32 ySpam{};      //(yesterday.ctSpam) - yesterday � ��� ����� � malicious
        ui32 yHam{};       //(yesterday.ctHam) - yesterday dlv or ham
        ui32 yMalicSpam{}; //(yesterday.ctMalicSpam) - yesterday malicious spam
        ui32 hSpam{};      //(history.ctSpam) - history � ��� ����� � malicious
        ui32 hHam{};       //(history.ctHam) - history dlv or ham
        ui32 hMalicSpam{}; //(history.ctMalicSpam) - history malicious spam
        bool isforward{};  //(IS_SF_FORWARD(today.bMask)) - ������� ������ ���������
        ui32 age{};        //((time(nullptr) - history.tFirstDeal) / 86400) - ���� � ������� ������� ��������� ip � ����

        TString Print() const;
    };
    struct TRuleStat {
        TString rulename{};   //��� �������
        ui32 count_ham{};   //���-�� ������������
        ui32 count_spam{};  //���-�� ������������
        ui32 count_malic{}; //���-�� ������������

        TRuleStat() = default;

        TRuleStat(const TString& rulenameA, ui32 counthamA, ui32 countspamA, ui32 countmalicA);
    };
    struct TSzStruct {
        ui32 m_source_size{};
        ui32 m_old_pack_size{};
        bool m_calc{};

        TString PrintCalc(ui32 newsize) const;
    };

    typedef TList<TRuleStat> TRuleStatList;
    typedef TVector<TString> TRules;

    ui32 GetStr(const char* source, ui32 source_size, char* destination, ui32 destination_size);

    bool GetResults2(TRules& Rules, double& /*SpamWeight*/, TStringBuf buff);

    void GetListRule2(const char* str, ui32 strsize, TRuleStatList& rlist);
}
