#include <library/cpp/string_utils/base64/base64.h>
#include <library/cpp/json/json_reader.h>
#include <util/string/strip.h>
#include <mail/so/spamstop/tools/so-common/parsers.h>
#include <util/generic/scope.h>
#include <library/cpp/logger/priority.h>
#include <util/string/split.h>
#include <util/string/builder.h>
#include "UaasShClient.h"

namespace NFuncClient {
    bool TUaas::CheckUaas(const TString& sUID, std::optional<TExpBoxes>& expBoxes, NJson::TJsonValue::TArray& expFlags, const TLog& logger) {
        if (sUID.empty() || sUID.length() == 0) {
            return false;
        }

        NCurl::TSimpleArtifacts artifacts;
        if (auto error = TRequestClient::Perform(artifacts, TRequestClient::TRequest{}
                                                                .SetRequest(TStringBuilder{} << "mail-backend?uuid=" << sUID))) {
            logger << (TLOG_ERR) << *error;
            return false;
        }

        constexpr TStringBuf ExpBoxes = "X-Yandex-ExpBoxes:";
        constexpr TStringBuf ExpFlags = "X-Yandex-ExpFlags:";

        for(TStringBuf h : artifacts.headers) {
            if(AsciiHasPrefixIgnoreCase(h, ExpBoxes)) {
                h.Skip(ExpBoxes.size());
                expBoxes.emplace(h);
                break;
            } else if(AsciiHasPrefixIgnoreCase(h, ExpFlags)) {
                h.Skip(ExpFlags.size());
                h = StripString(h);

                for (auto it : StringSplitter(h).Split(',')) {
                    const auto tok = it.Token();

                    const auto decoded = Base64DecodeUneven(tok);

                    auto json = NJson::ReadJsonFastTree(decoded);

                    expFlags.emplace_back(std::move(json));
                }
            }
        }

        return true;
    }
} /* namespace NFuncClient */
