#pragma once

#include <mail/so/spamstop/tools/so-clients/general_shingler_put.h>
#include "shclient_helper.h"
#include <mail/so/spamstop/tools/so-clients/turlstat.h>

namespace NFuncClient {
    template<bool isConst> using TUrlStatisticInfoImpl = std::pair<std::conditional_t<isConst, const TUrlInfo*, TUrlInfo*>, std::conditional_t<isConst, const TUrlStatistic*, TUrlStatistic*>>;
    using TUrlStatisticInfo = TUrlStatisticInfoImpl<false>;
    using TUrlStatisticInfoConst = TUrlStatisticInfoImpl<true>;

    class TUrlPutRequest : public NGeneralShingler::TPutRequest {
    public:
        TUrlPutRequest(const TVector<TUrlStatisticInfoConst>& data) {
            NJson::TJsonValue::TArray messages;
            for (const auto& it : data) {
                auto& value = messages.emplace_back(NJson::JSON_MAP);

                value["shingle"] = it.first->shingle_host;
                value[it.second->isSpam ? "spam" : "ham"] = 1;
            }

            AddMessage("today", messages);
            AddMessage("history", messages);
        }
    };
    class TUrlReputation : CShClientHelper {
    public:
        using CShClientHelper::CShClientHelper;
        bool Get(TUrlStatisticVector& data, const TLog& logger) const;
        bool Put(const TUrlPutRequest& request, const TLog& logger) const;

        bool Complaint(const TUrlStatisticVector& data, bool spam, const TLog& logger) const;

        bool Resolve(TUrlStatisticVector& data, const TLog& logger) const;
    };

    template<typename T>
    static auto GetUrlInfo(T& data, bool checkNoAdd) {
        using TVectorType = TVector<TUrlStatisticInfoImpl<std::is_const<T>::value>>;
        TVectorType hosts, links;
        for (auto& item : data) {
            if (checkNoAdd && item.noAddStorage)
                continue;

            if (!item.checkUrl.NoData())
                (item.isLink? &links: &hosts)->emplace_back(&item.checkUrl, &item);

            if (item.isLink && !item.longUrl.NoData())
                hosts.emplace_back(&item.longUrl, &item);
        }

        return std::make_pair(std::move(hosts), std::move(links));
    }

    class TUrlComplaintRequest : public NGeneralShingler::TPutRequest {
    public:
        TUrlComplaintRequest(const TVector<TUrlStatisticInfoConst>& data, bool spam) {
            NJson::TJsonValue value(NJson::JSON_MAP);
            value[spam ? "complaint_spam" : "complaint_ham"] = 1;
            NJson::TJsonValue& shingle = value["shingle"];

            NJson::TJsonValue::TArray messages;
            for (const auto& it : data) {
                shingle = it.first->shingle_host;
                messages.push_back(value);
            }

            AddMessage("today", messages);
            AddMessage("history", messages);
        }
    };
} /* namespace NFuncClient */
