#pragma once

#include "single_request_client.h"
#include "mail/so/spamstop/tools/so-common/anyvalue.h"
#include <library/cpp/json/json_value.h>
#include <vector>
#include <map>

#define MAX_U32_2BLN 2000000000
#define MAX_U16_32K 32000

//**********************************************************************************************************************************
//                                                        TUserRepShingle
//**********************************************************************************************************************************

class TUserRepShingle {
private:
    ui64 m_user_uid;

public:
    TUserRepShingle();
    TUserRepShingle(ui64 uid);
    ~TUserRepShingle();

    ui64 UserUid() const {
        return m_user_uid;
    }
    TString UserUidS() {
        return UI64ToStroka(m_user_uid);
    }
};

//**********************************************************************************************************************************
//                                                        TUserRepRequest
//**********************************************************************************************************************************

#define URS_SHINGLE_ID "id" //shingle

namespace USRREP {
    enum TSpamType { UNKNOWN,
                     HAM,
                     SPAM,
                     MALIC };
    enum TViewIdx { RQSTTYPE,
                    RASM,
                    STORFNAME,
                    VIEWTEXT,
                    LOGTEXT };
    enum TRasmType { RDATE,
                     RUI8,
                     RUI16,
                     RUI32 };
    enum TUseType { USE_UNKNOWN,
                    USE_FULL,
                    USE_FAST,
                    USE_BOTH };

    enum TFieldId {
        UR_UDATE = 0,                   //time_t
        UR_karma = 1,                   //ui32
        UR_KarmaStatus = 2,             //ui32
        UR_FM_FirstTime = 3,            //time_t
        UR_FM_LastTime = 4,             //time_t
        UR_ComplaintHam = 5,            //ui32
        UR_ComplaintSpam = 6,           //ui32
        UR_Ham = 7,                     //ui32
        UR_Spam = 8,                    //ui32
        UR_SendHam = 9,                 //ui32
        UR_SendSpam = 10,               //ui32
        UR_UniqueCompluser = 11,        //ui32
        UR_UniqueNetworks = 12,         //ui32
        UR_UniqueGeo = 13,              //ui16
        UR_OutBitMask = 14,             //ui32
        UR_ActiveDays = 15,             //ui16
        UR_MaxRecipientCount = 16,      //ui16
        UR_BounceCount = 17,            //ui16
        UR_BounceSpamCount = 18,        //ui16
        UR_BounceTodayUnknownRcpt = 19, //ui16
        UR_BounceTodaySpamRcpt = 20,    //ui16
        UR_BounceTotalUnknownRcpt = 21, //ui32
        UR_BounceTotalSpamRcpt = 22,    //ui32
        UR_BounceLastRcptType = 23,     //ui8
        UR_BounceLastDate = 24,         //time_t
        UR_PddDate = 25,                //time_t
        UR_PddMailboxCount = 26,        //ui32
        UR_PddResQuota = 27,            //ui32
        UR_PddFreeRegistration = 28,    //ui8
        UR_PddIsManualReg = 29,         //ui8
        UR_PddFBounceToday = 30,        //ui32
        UR_PddFBounceQAll = 31,         //ui32
        UR_LastDecision = 32,           //ui16
        UR_UnlimitUser = 33,            //ui8
        UR_T_SpamMails = 34,            //ui16
        UR_T_HamMails = 35,             //ui16
        UR_T_MalicMails = 36,           //ui16
        UR_T_SpamRecipients = 37,       //ui16
        UR_T_HamRecipients = 38,        //ui16
        UR_T_MalicRecipients = 39,      //ui16
        UR_T_UniqRecipients = 40,       //ui16
        UR_T_UniqGeo = 41,              //ui16
        UR_T_MySelfMails = 42,          //ui32
        UR_F_LastDateSecondCheck = 43,  //time_t
        UR_A_F_HamMails = 44,           //ui32
        UR_A_F_SpamMails = 45,          //ui32
        UR_A_F_MalicMails = 46,         //ui32
        UR_T_F_HamMails = 47,           //ui16
        UR_T_F_SpamMails = 48,          //ui16
        UR_T_F_MalicMails = 49,         //ui16
        UR_L_F_HamMails = 50,           //ui16
        UR_L_F_SpamMails = 51,          //ui16
        UR_L_F_MalicMails = 52,         //ui16
        UR_F_CacheCount = 53,           //ui16
        UR_F_CacheDate = 54,            //time_t
        UR_Reserve32_1 = 55,            //ui32
        UR_Reserve32_2 = 56,            //ui32
        UR_Reserve16_1 = 57,            //ui16
        UR_Reserve16_2 = 58,            //ui16
        UR_END = 59
    };

    struct TFieldIdStat{
        // f - full, s - fast, a - both, u - unknown
        enum TRequestType{Both, Full, Fast, Unknown};
        //s - date, 1 - ui8, 2 - ui16, 4 - ui32
        enum TFieldType{Double, Ui64, Ui32, Ui16, Ui8, String, Date};

        TFieldIdStat(TRequestType requestType, TFieldType fieldType, TString name, TString prettyName, TString logName)
                : requestType(requestType),
                  fieldType(fieldType),
                  name(std::move(name)),
                  prettyName(std::move(prettyName)),
                  logName(std::move(logName))
        {}

        TRequestType requestType;
        TFieldType fieldType;
        TString name, prettyName, logName;
    };

    const TFieldIdStat & GetFieldStat(TFieldId id);

    TString getident(TViewIdx index, const TString& rqsttype, const TString& rasm, const TString& storfname_s, const TString& viewtext_s, const TString& logtext_s);

    TString URToText_(TFieldId fn, TViewIdx idx);
    TFieldId STORFNToFieldId(const TString& storname);

    TString STORFN(TFieldId fn);  //return fieldname in storage
    TString VIEWFN(TFieldId fn);  //return fieldname for user interface
    TString LOGFN(TFieldId fn);   //return fieldname for log
    TRasmType RASMF(TFieldId fn); //field type (s - date, 1 - ui8, 2 - ui16, 4 - ui32)
    TString RASMFs(TFieldId fn);
    TUseType USEF(TFieldId fn); //use field (f - full, s - fast, a - both, u - unknown)
    TString USEFs(TFieldId fn);

    bool IsFullField(TFieldId fn);
    bool IsFastField(TFieldId fn);

    void CheckDublicatFName();

    enum TSource { SRC_UNKNOWN,
                   SRC_STORAGE,
                   SRC_CACHE };

    struct TCntData {
        TSource m_source;
        ui32 m_gettime;
        bool m_empty;
        bool m_error;
        TString m_error_text;
        ui32 m_counters[USRREP::UR_END];
        ui8 m_setflags[USRREP::UR_END];

        TCntData();
        void Clear();

        TString SerializeCounters();
        TString SerializeFlags();
        bool DeserializeCounters(const TString& data_s);
        bool DeserializeFlags(const TString& data_s);

        void FillPutAllDebug();
        void FillPutFullDebug();
        void FillPutFullMaxDebug();
        TString PrintDataToLog();
        TString PrintOnlyCountersToLog();
        TString PrintOnlyCountersToLog2();
        NJson::TJsonValue ToJson() const;
        void FromJson(const NJson::TJsonValue & value);
    };

    TString TSourceToTString(TSource value);

    typedef THashMap<TFieldId, nosql::AnyValue> TReputHash;
    typedef TReputHash::iterator TReputHashIt;

    TString AnyValueReputToTString(TReputHash::const_iterator& hit, nosql::TDataCounters& counters);
    TString ReputHashToTString(const TReputHash& hash);
    bool pTStringToReputHash(const char* pdatastr, size_t pdatastrlen, TReputHash& hash, TString& err_str);
    bool TStringToReputHash(const TString& datastr, TReputHash& hash, TString& err_str);

}

class TUserRepRequest {
private:
    TUserRepShingle m_shingle;
    USRREP::TCntData m_set_counters;
    USRREP::TCntData m_res_counters;
    bool m_res_limit_th;

public:
    TUserRepRequest();
    ~TUserRepRequest();

    bool CheckSetsIncrs(USRREP::TReputHash& sets, USRREP::TReputHash& incrs); //true - OK, false - FAILED (compare field in sets and incrs)
    bool CheckPutFull();                                                      //true - OK, false - FAILED (m_set_counters has non full field)
    bool CheckPutFast(USRREP::TReputHash& sets, USRREP::TReputHash& incrs);   //true - OK, false - FAILED (sets or incrs have non fast field)

    TString GetRequestFull();
    bool PutRequestFull(TString& request, TString& error_s);
    TString GetRequestFast();
    TString PutRequestFast(USRREP::TReputHash& sets, USRREP::TReputHash& incrs, bool only_cache);
    NJson::TJsonValue ToJson() const;
    NJson::TJsonValue ResultToJson() const;
    bool FillDataFromServer(const TString& uid, nosql::HashMap& data);
    bool FillDataFromGeneralServer(const NJson::TJsonValue & value);

    void FillPutAllDebug();
    void FillPutFullDebug();
    void FillPutFullMaxDebug();

public:
    //!!!for spdaemon!!!
    TUserRepRequest(ui64 uid);
    TUserRepRequest(const char* strUid);

    void ChangeUid(ui64 uid);
    void ChangeUid(const char* strUid);

    bool Undefined();   //uid == 0
    ui64 UserUid() const;     //get uid as ui64
    TString UserUidS(); //get uid as stroka
    void Clear();       //clear all counters

    void SetFieldValue(USRREP::TFieldId fntype, ui32 value); //set field value

    bool GetEmpty();             //true - is empty
    USRREP::TSource GetSource(); //SRC_UNKNOWN, SRC_STORAGE, SRC_CACHE
    ui32 GetReceiveDataTime();
    bool GetError();
    TString GetErrorText();
    bool GetFieldValue(USRREP::TFieldId fntype, ui32& value); //get field value (return true - ok, false - no data)

    TString PrintSetCounters();  //print set counters
    TString PrintSetCounters2(); //print set counters with fieldname
    TString PrintResCounters();  //print res counters

    const USRREP::TCntData& getResultRawCounters() const;
};

//**********************************************************************************************************************************
//                                                      CUserReputationClient
//**********************************************************************************************************************************

namespace NFuncClient {
    class TUserReputationClient {
        class TGetter : TRequestClient {
        public:
            using TRequestClient::TRequestClient;
            bool Perform(TUserRepRequest& userrqst, const TLog& logger) const;
        };

        class TFullUpdater : TRequestClient {
        public:
            using TRequestClient::TRequestClient;
            bool Perform(const TUserRepRequest& userrqst, const TLog& logger) const;
        };

        class TFastUpdater : TRequestClient {
        public:
            using TRequestClient::TRequestClient;
            bool Perform(const TUserRepRequest& userrqst, const USRREP::TReputHash& sets, const USRREP::TReputHash& incrs, const TLog& logger) const;
        };

    public:
        explicit TUserReputationClient(const TRequestClient::TArgs& args)
        : Getter(PrepareForGet(args))
        , FullUpdater(PrepareForFull(args))
        , FastUpdater(PrepareForFast(args)) {}

    public:
        const TGetter Getter;
        const TFullUpdater FullUpdater;
        const TFastUpdater FastUpdater;
    private:
        ui32 GetStr(const char* source, ui32 source_size, char* destination, ui32 destination_size);

        static TRequestClient::TArgs PrepareForGet(TRequestClient::TArgs args) {
            if (args.Config.YasmPrefix)
                args.Config.YasmPrefix += "_GET";
            return args;
        }
        static TRequestClient::TArgs PrepareForFull(TRequestClient::TArgs args) {
            if (args.Config.YasmPrefix)
                args.Config.YasmPrefix += "_FULL";
            return args;
        }
        static TRequestClient::TArgs PrepareForFast(TRequestClient::TArgs args) {
            if (args.Config.YasmPrefix)
                args.Config.YasmPrefix += "_FAST";
            return args;
        }
    };
}

