#include <mail/so/libs/talkative_config/config.h>
#include <mail/so/libs/pool/pool.h>
#include <mail/so/libs/curl/curl.h>
#include <util/string/strip.h>

#include "config.h"

TClientConfig TClientConfig::ReadFromConfig(const NConfig::TConfig& config) {
    const auto& map = config.Get<NConfig::TDict>();

    TClientConfig clientConfig;
    if (auto it = MapFindPtr(map, "Host")) {
        clientConfig.Host = StripString(NTalkativeConfig::Get<TString>(*it));
    }
    if (auto it = MapFindPtr(map, "Port")) {
        clientConfig.Port = NTalkativeConfig::As<ui16>(*it);
    }
    if (auto it = MapFindPtr(map, "ConnectTimeout")) {
        clientConfig.ConnectTimeout = NTalkativeConfig::As<TDuration>(*it);
    }
    if (auto it = MapFindPtr(map, "RequestTimeout")) {
        clientConfig.RequestTimeout = NTalkativeConfig::As<TDuration>(*it);
    }

    clientConfig.PoolParams = TPoolParams(config);

    {
        auto sslOpts = NCurl::TSSL(NTalkativeConfig::Get<NConfig::TDict>(config));
        if(!sslOpts.Empty())
            clientConfig.Ssl = std::move(sslOpts);
    }

    {
        auto retryOpts = NCurl::TRetries(NTalkativeConfig::Get<NConfig::TDict>(config));
        if(retryOpts.Count != 0)
            clientConfig.Retries = std::move(retryOpts);
    }

    if(auto it = MapFindPtr(map, "YasmPrefix")) {
        clientConfig.YasmPrefix = StripString(NTalkativeConfig::Get<TString>(*it));
    }

    if(auto it = MapFindPtr(map, "tvm_service")) {
        clientConfig.TvmServiceName = StripString(NTalkativeConfig::Get<TString>(*it));
    }

    if(auto it = MapFindPtr(map, "compression")) {
        clientConfig.Compression = StripString(NTalkativeConfig::Get<TString>(*it));
    }

    return clientConfig;
}

IOutputStream& operator<<(IOutputStream& stream, const TClientConfig& config) {
    const auto& Host = config.Host;
    const auto& Port = config.Port;
    const auto& ConnectTimeout = config.ConnectTimeout;
    const auto& RequestTimeout = config.RequestTimeout;
    const auto& CA = config.Ssl.GetOrElse({}).caCertFile;
    const auto& Compression = config.Compression;
    return stream << LabeledOutput(Host, Port, ConnectTimeout, RequestTimeout, CA, Compression);
}
