#pragma once

#include <mail/so/libs/pool/pool.h>
#include <mail/so/libs/curl/curl.h>

namespace NConfig {
    class TConfig;
}

struct TClientConfig{
    TClientConfig() = default;
    static TClientConfig ReadFromConfig(const NConfig::TConfig& config);
    friend IOutputStream& operator<<(IOutputStream& stream, const TClientConfig& config);

    TString Host;
    ui16 Port = 80;
    TDuration ConnectTimeout = TDuration::MilliSeconds(100);
    TDuration RequestTimeout = TDuration::MilliSeconds(150);

    TPoolParams PoolParams;
    TMaybe<NCurl::TSSL> Ssl;
    TMaybe<NCurl::TRetries> Retries;
    TString YasmPrefix;

    TString TvmServiceName;

    TString Compression; /// https://a.yandex-team.ru/arc/trunk/arcadia/library/cpp/http/io/compression.cpp#L17
};
