#include <util/thread/pool.h>
#include "single_request_client.h"

namespace NFuncClient {
    class TDkimUpdater : public TRequestClient {
    public:
        using TRequestClient::TRequestClient;

        void Update(const TLog& logger, const TString &from, const TVector<TString>& dkimDomains, TInstant mailTimestamp, size_t inc) const {
            TCgiParameters cgiParameters;

            cgiParameters.InsertUnescaped("from", from);
            for(const TString& domain : dkimDomains) {
                cgiParameters.InsertUnescaped("dkim-domain", domain);
            }
            cgiParameters.InsertUnescaped("timestamp", ToString(mailTimestamp.Seconds()));
            cgiParameters.InsertUnescaped("count", ToString(inc));

            NCurl::TSimpleArtifacts artifacts;
            if (auto error = TRequestClient::Perform(artifacts, TRequest{}
                    .SetRequest("api/async/so/update-dkim-stats?" + cgiParameters.QuotedPrint()))) {
                logger << (TLOG_ERR) << *error << ' ' << artifacts.body.Str();
            }
        }
    };
}
