
#include <library/cpp/cgiparam/cgiparam.h>
#include <util/string/builder.h>
#include <library/cpp/logger/priority.h>
#include <mail/so/spamstop/tools/so-common/so_log.h>
#include <util/stream/format.h>
#include "rbl_producer.h"

namespace NFuncClient {
    TRblProducer::TIpsList &TRblProducer::TIpsList::operator+=(TIpsList &&anotherList) {
        White.insert(anotherList.White.begin(), anotherList.White.end());
        Black.insert(anotherList.Black.begin(), anotherList.Black.end());
        Malic.insert(anotherList.Malic.begin(), anotherList.Malic.end());
        return *this;
    }

    void TRblProducer::Perform(const TIpsList &ips) const {


        for (const auto& [list, type] : {
                std::make_tuple(std::cref(ips.Black), TStringBuf("fast-spam")),
                std::make_tuple(std::cref(ips.White), TStringBuf("fast-ham")),
                std::make_tuple(std::cref(ips.Malic), TStringBuf("fast-reject")),
        }) {
            TCgiParameters parameters;

            parameters.InsertUnescaped("rbl-type", type);
            parameters.InsertUnescaped("ttl", TStringBuilder{} << HumanReadable(Ttl));

            for (const auto& ip : list) {
                parameters.ReplaceUnescaped("ip", ip);
                TRequestClient::Perform(TRequestClient::TRequest{}.SetRequest(TStringBuilder{} << "modify?" << parameters.Print()));
            }
        }
    }
} /* namespace NFuncClient */
