#pragma once

#include "single_request_client.h"

namespace NFuncClient {
    class TRblProducer : TRequestClient {
    public:
        TRblProducer(TRequestClient::TArgs args, TDuration ttl)
        : TRequestClient(std::move(args))
        , Ttl(ttl) {}

        struct TIpsList {
            TIpsList &operator+=(TIpsList &&anotherList);

            THashSet<TString> White, Black, Malic;
        };

        void Perform(const TIpsList &ips) const;
    private:
        TDuration Ttl;
    };

} /* namespace NFuncClient */

struct TIpsListSafe {

    NFuncClient::TRblProducer::TIpsList Move() {
        TWriteGuard g(Mutex);
        return std::exchange(list, {});
    }

    void AddWhite(TString ip) {
        TReadGuard g(Mutex);
        list.White.emplace(std::move(ip));
    }
    void AddBlack(TString ip) {
        TReadGuard g(Mutex);
        list.Black.emplace(std::move(ip));
    }
    void AddMalic(TString ip) {
        TReadGuard g(Mutex);
        list.Malic.emplace(std::move(ip));
    }

private:
    TRWMutex Mutex;
    NFuncClient::TRblProducer::TIpsList list;
};

