#pragma once

#include <util/generic/scope.h>
#include <util/string/builder.h>
#include <mail/so/spamstop/tools/so-common/so_log.h>
#include <mail/so/spamstop/tools/so-common/sobase64.h>
#include <mail/so/libs/syslog/so_log.h>
#include "single_request_client.h"
#include "RequestBase.h"

namespace NFuncClient {
    class CShClientHelper {
    public:
        class TUpdater : TRequestClient {
        public:
            using TRequestClient::TRequestClient;
            bool Perform(const CPutRequest& request, const TLog& logger) const {
                if (request.empty()) {
                    return false;
                }
                NCurl::TSimpleArtifacts artifacts;
                if (auto error = TRequestClient::Perform(artifacts, TRequest{}
                    .SetRequest(TStringBuilder{} << request.getIdent() << '?' << request.getQueryParams())
                    .SetData(request.getRequestData()))) {
                    logger << (TLOG_ERR) << *error;
                    return false;
                }
                return true;
            }
        };

        class TGetter : TRequestClient {
        public:
            using TRequestClient::TRequestClient;
            bool Perform(CGetRequest& request, const TLog& logger) const {
                if (request.empty()) {
                    return false;
                }

                NCurl::TSimpleArtifacts artifacts;
                if (auto error = TRequestClient::Perform(artifacts, TRequest{}
                    .SetRequest(TStringBuilder{} << request.getIdent() << '?' << request.getQueryParams())
                    .SetData(request.getRequestData()))) {
                    logger << (TLOG_ERR) << *error;
                    return false;
                }

                if (request.needDecompress()) {
                    TString uncompress_responce;
                    bool warning_size = false;
                    TString err_str;
                    if (!Unbase64AndUncompress(artifacts.body.Str().c_str(), artifacts.body.Str().length(), warning_size, uncompress_responce, err_str)) {
                        PushError();
                        return false;
                    }

                    request.parseFromString(uncompress_responce);
                } else
                    request.parseFromString(artifacts.body.Str());

                return true;
            }
        };

        explicit CShClientHelper(const TRequestClient::TArgs& args)
            : Updater(args.PopulateWithYasm("_PUT"))
            , Getter(args.PopulateWithYasm("_GET")) {}

    protected:
        const TUpdater Updater;
        const TGetter Getter;
    };
} // namespace NFuncClient
