#pragma once

#include <util/generic/ptr.h>
#include <library/cpp/unistat/unistat.h>
#include <library/cpp/tvmauth/client/facade.h>
#include <mail/so/libs/curl/curl.h>
#include <library/cpp/http/io/compression.h>
#include <library/cpp/logger/log.h>

#include "config.h"

class TRequestClient {
public:
    struct TArgs{
        TArgs();

        TArgs& SetPool(TAtomicSharedPtr<NCurl::TPool> pool);
        TArgs& SetTvm(TAtomicSharedPtr<NTvmAuth::TTvmClient> client);
        TArgs PopulateWithYasm(const TStringBuf& s) const;

        explicit TArgs(TClientConfig config);

        TClientConfig Config;
        TAtomicSharedPtr<NCurl::TPool> Pool;
        TAtomicSharedPtr<NTvmAuth::TTvmClient> TvmClient;
    };

    struct TRequest{
        TRequest&& SetRequest(TString value) && noexcept;
        TRequest&& SetData(TString value) && noexcept;
        TRequest&& SetData(const NJsonWriter::TBuf& buf) && noexcept;
        TRequest&& SetHeaders(TVector<TString> value) && noexcept;

        TMaybe<TString> Request;
        TMaybe<TString> Data;
        TMaybe<TVector<TString>> Headers;
    };

    explicit TRequestClient(TArgs args) noexcept;

    TMaybe<NCurl::TError> Perform(TRequest request = {}) const noexcept;

    TMaybe<NCurl::TError> Perform(NCurl::TSimpleArtifacts&& artifacts, TRequest request = {}) const;

    TMaybe<NCurl::TError> Perform(NCurl::TSimpleArtifacts& artifacts, TRequest request = {}) const;

protected:
    void PushError() const noexcept;

private:
    static NUnistat::IHolePtr DrillHole(const TClientConfig& config, const TStringBuf name);

    static NUnistat::IHolePtr DrillHistHole(const TClientConfig& config, const TStringBuf name);

private:
    const TClientConfig Config;
    const TAtomicSharedPtr<NCurl::TPool> Pool;
    const NCurl::TPoolTraits PoolTraits;
    const NUnistat::IHolePtr ErrorStatter, PoolStatter, Stats2xx, Stats4xx, Stats5xx, TvmErrorStatter, TimingStatter;
    const TAtomicSharedPtr<NTvmAuth::TTvmClient> TvmClient;
    const TCompressionCodecFactory::TEncoderConstructor* EncoderCtor;
};
