#pragma once

#include <mail/so/spamstop/tools/so-clients/general_shingler_impl.h>

namespace NGeneralShingler{

    class TGetRequest : public TRequestImpl<NFuncClient::CGetRequest, TMessageType::Get> {
    public:
        TString getLogCode() const override {
            return "GENGET";
        };

        TString toLog() const override {
            return NJson::WriteJson(&answer, true);
        };

        bool needDecompress() const final {
            return false;
        }

        void parseFromString(const TString& s) override {
            NJson::ReadJsonTree(s, &answer, true);
            ParseAnswer(answer);
        }

        virtual void ParseAnswer(const NJson::TJsonValue &) {};
        const NJson::TJsonValue & GetAnswer() const { return answer; }

    private:
        NJson::TJsonValue answer;
    };

}   //  namespace NGeneralShingler
