#pragma once

#include <mail/so/spamstop/tools/general_shingler/data/message.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/RequestBase.h>
#include <mail/so/spamstop/tools/so-common/json_util.h>
#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/json_writer.h>

namespace NGeneralShingler{

    template<typename T, TMessageType default_type>
    class TRequestImpl : public T {
    public:

        void AddMessage(const TString & scheme, NJson::TJsonValue::TArray && fields, TMessageType type = default_type) {
            messages.emplace_back(scheme, type, std::move(fields));
        }

        void AddMessage(const TString & scheme, const NJson::TJsonValue::TArray & fields, TMessageType type = default_type) {
            messages.emplace_back(scheme, type, fields);
        }

        void AddMessage(const TVector<TString> & schemes, NJson::TJsonValue::TArray && fields, TMessageType type = default_type) {
            messages.emplace_back(schemes, type, std::move(fields));
        }

        void AddMessage(const TVector<TString> & schemes, const NJson::TJsonValue::TArray & fields, TMessageType type = default_type) {
            messages.emplace_back(schemes, type, fields);
        }

        TString getIdent() const final {
            return "api/v1";
        };

        bool empty() const override {
            return messages.empty();
        };


        friend NJsonWriter::TBuf& PrintJson(const TRequestImpl& request, NJsonWriter::TBuf &writer) {
            writer.BeginList();
            for (const auto & m : request.messages) {
                writer.BeginObject();
                writer.WriteKey("type").WriteString(ToString(m.GetType()));

                writer.WriteKey("scheme");
                writer.BeginList();
                for(const auto & scheme : m.GetSchemes()) {
                    writer.WriteString(scheme);
                }
                writer.EndList();

                if(!m.GetShardedFields().empty()) {
                    writer.WriteKey("fields");
                    writer.BeginList();
                    for (const auto & sharded : m.GetShardedFields())
                        for (const auto & f : sharded.fields)
                            writer.WriteJsonValue(&f);
                    writer.EndList();
                }
                writer.EndObject();
            }
            return writer.EndList();
        }

        TString getRequestData() const override {
            NJsonWriter::TBuf jsData;
            jsData << *this;
            return jsData.Str();
        };

        TString toLog() const override {
            return "";
        };

        TString getQueryParams() const final {
            return "";
        };

    private:
        TVector<TMessage> messages;
    };

}   //  namespace NGeneralShingler
