#pragma once

#ifndef kshingle_H
#define kshingle_H

#include <library/cpp/cgiparam/cgiparam.h>

#include <list>
#include "ktime.h"
#include <mail/so/spamstop/tools/so-common/urlparser.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include "freemail.h"
#include "tuserid.h"

enum TShingleValue { KHAM,
    KSPAM,
    KMALIC,
    KUNDEF,
    KEND };
enum TKMailType { KOUTMAIL,
    KOUTMAILHAM,
    KOUTMAILSPAM,
    KINMAIL,
    KINMAILHAM,
    KINMAILSPAM,
    KUNKNOWN };
enum TResponceType { KTHOST,
    KTFROMTO,
    KTCOMPL,
    KTFROMSTAT,
    KTDLVSH,
    KTFREEMAIL,
    KTUNKNOWN,
    KTPDD,
    KTBOUNCE,
    KTSENDER,
    KTDOMAIN,
    KTPSNDR };
enum TComplaintType { KCFROM,
    KCMESS,
    KCSUBJECT,
    KCBEENSENDER,
    KCLIST,
    KCFROMDOMEN,
    KCRETURNPATH,
    KCUNKNOWN,
    KCPSNDR,
    KCPSNDR_NOFROM };
enum TStatType { KSFROM,
    KSBEENSENDER,
    KSLIST,
    KSUNKNOWN };
enum TComplSpamType { CS_HAM,
    CS_SPAM,
    CS_UNSUBSCRIBE,
    CS_UNKNOWN = 100 };
enum TComplSource { SRC_WEB,
    SRC_IMAP,
    SRC_OTRS,
    SRC_CRM,
    SRC_MOBILE,
    SRC_FURITA,
    SRC_FBL,
    SRC_FASTSRVLOG,
    SRC_UNKNOWN = 100 };

#define SPAMTYPETEXT_HAM1 "antifoo"
#define SPAMTYPETEXT_SPAM1 "foo"
#define SPAMTYPETEXT_UNSUBSCRIBE1 "unsubscribe"

TString TComplSpamTypeToStroka(TComplSpamType spam);       //конвертируем тип TComplSpamType в строку
TComplSpamType StrokaToTComplSpamType(const TString& str); //конвертируем строку в тип TComplSpamType
bool TComplSpamTypeToSpam(TComplSpamType spam);            //решение по разным типам: true - спам, false - хам
TString TComplSpamTypeToSpamS(TComplSpamType spam);        //решение по разным типам в виде текста

//***************************************************************************************
//                      TEMailFunction - класс для работы с email адресами
//***************************************************************************************

class TEMailFunction {
private:
    enum TType { TBASE,
        TSOFT };

private:
    static constexpr int MAX_SYMBOL_COUNT = 256;

    bool symboltable[MAX_SYMBOL_COUNT];
    bool symboltable_domenname[MAX_SYMBOL_COUNT];
    bool symboltable_soft[MAX_SYMBOL_COUNT];
    bool symboltable_domenname_soft[MAX_SYMBOL_COUNT];

    static bool IsBorderSymbolInit(unsigned char symb, bool domenname) {
        bool res = true;

        if ((symb >= static_cast<ui8>('A')) && (symb <= static_cast<ui8>('Z'))) //A .. Z
            res = false;
        else if ((symb >= static_cast<ui8>('a')) && (symb <= static_cast<ui8>('z'))) //a .. z
            res = false;
        else if ((symb >= static_cast<ui8>('0')) && (symb <= static_cast<ui8>('9'))) //0 .. 9
            res = false;
        else if (symb == static_cast<ui8>('-'))
            res = false;
        else if ((!domenname) && (symb == static_cast<ui8>('_')))
            res = false;
        else if (symb == static_cast<ui8>('.'))
            res = false;

        return res;
    }

    static bool IsBorderSymbolInitSoft(unsigned char symb, bool domenname) {
        bool res = true;

        if ((symb >= static_cast<ui8>('A')) && (symb <= static_cast<ui8>('Z'))) //A .. Z
            res = false;
        else if ((symb >= static_cast<ui8>('a')) && (symb <= static_cast<ui8>('z'))) //a .. z
            res = false;
        else if ((symb >= static_cast<ui8>('0')) && (symb <= static_cast<ui8>('9'))) //0 .. 9
            res = false;
        else if (symb == static_cast<ui8>('-'))
            res = false;
        else if ((!domenname) && (symb == static_cast<ui8>('_')))
            res = false;
        else if (symb == static_cast<ui8>('.'))
            res = false;
        else if ((!domenname) && (symb == static_cast<ui8>('+')))
            res = false;
        else if ((!domenname) && (symb == static_cast<ui8>('=')))
            res = false;

        return res;
    }

    bool IsBorderSymbol(unsigned char symb, bool domenname) const;
    bool IsBorderSymbolSoft(unsigned char symb, bool domenname) const;
    TStringBuf GetFirstEMailAddressA(const TStringBuf& str, TType type) const;
    TStringBuf GetFirstEMailAddressWitchMailtoA(const TStringBuf& str, TType type) const;

public:
    TEMailFunction() {
        //base tables
        for (size_t i = 0; i < MAX_SYMBOL_COUNT; i++) {
            symboltable[i] = IsBorderSymbolInit(i, false);
            symboltable_domenname[i] = IsBorderSymbolInit(i, true);
        }

        //soft tables
        for (size_t i = 0; i < MAX_SYMBOL_COUNT; i++) {
            symboltable_soft[i] = IsBorderSymbolInitSoft(i, false);
            symboltable_domenname_soft[i] = IsBorderSymbolInitSoft(i, true);
        }
    }

    TStringBuf GetFirstEMailAddress(const TStringBuf& str) const;
    TStringBuf GetFirstEMailAddressWitchMailto(const TStringBuf& str) const;

    TStringBuf GetFirstEMailAddressSoft(const TStringBuf& str) const;
};

//***************************************************************************************
//                                Functions
//***************************************************************************************

//структура хранения полей LIST-*
struct TFieldListStrings {
    const TString& list;          //содержимое поля "List-:" без самого заголовка
    const TString& listpost;      //содержимое поля "List-Post:" без самого заголовка
    const TString& listowner;     //содержимое поля "List-Owner:" без самого заголовка
    const TString& listsubscribe; //содержимое поля "List-Subscribe:" без самого заголовка
    const TString& listother;     //содержимое полей List-* без заголовков через запятую

    TFieldListStrings(const TString& list, const TString& listpost, const TString& listowner, const TString& listsubscribe, const TString& listother)
            : list(list), listpost(listpost), listowner(listowner), listsubscribe(listsubscribe), listother(listother){}
};

//Возвращает тип value в разных представлениях
TString TComplaintTypeToText(TComplaintType value);
ui8 TComplaintTypeToInt(TComplaintType value);
TComplaintType IntToTComplaintType(ui8 value);

//Возвращает тип value в разных представлениях
TString TStatTypeToText(TStatType value);
ui8 TStatTypeToInt(TStatType value);
TStatType IntToTStatType(ui8 value);

//Возвращает адрес beensender
TString ParseSenderXBeenThereFields(const TStringBuf& from, const TStringBuf& sender, const TStringBuf& xbeenthere, const TStringBuf& deliveredto);
//from - адрес из from
//sender - содержимое поля Sender: без заголовка
//xbeenthere - содержимое поля X-BeenThere: без заголовка
//deliveredto - адрес из поля Delivered-To (результат функции ParseDeliveredTo)

//Возвращает адрес list
TString ParseListFields(const TStringBuf& from, const TStringBuf& beensender, const TStringBuf& deliveredto, const TFieldListStrings& list);
//from - адрес из from
//beensender - адрес beensender (результат функции ParseSenderXBeenThereFields)
//deliveredto - адрес из поля Delivered-To (результат функции ParseDeliveredTo)
//list - заполненная структура полями LIST-* без заголовков

//Возвращает домен из поля from, в качестве домена берем домен минимального уровня, то-есть уровень домена должен на единицу превышать уровень зоны.
TStringBuf GetFromDomen(const TStringBuf& from, TZoneDetector& TDC);
//from - адрес из from (email)
//TZoneDetector - ссылка объект, умеющий определять зону

//Возвращает домен из поля from (все после @)
TStringBuf GetFromDomenFull(const TStringBuf& from);

//***************************************************************************************
//                            TPackShingleType
//***************************************************************************************

class TPackShingleType {
private:
    TComplaintType m_shingle_type;
    ui8 m_value;

public:
    TPackShingleType() {
        m_shingle_type = KCUNKNOWN;
        m_value = 0;
    }
    TPackShingleType(const TComplaintType& shingle_type, const ui8& value) {
        m_shingle_type = shingle_type;
        m_value = value;
    }
    TPackShingleType(const TComplaintType& shingle_type, const int& value) : m_shingle_type(shingle_type),
                                                                             m_value((ui8) value) {}
    TPackShingleType(const TComplaintType& shingle_type, const bool& value) {
        m_shingle_type = shingle_type;
        if (value)
            m_value = 1;
        else
            m_value = 0;
    }
    TPackShingleType(const TComplaintType& shingle_type, const TComplSpamType& value) {
        m_shingle_type = shingle_type;
        m_value = value;
    }

    explicit TPackShingleType(const ui32& value) {
        ui32 type = 0;

        m_value = static_cast<ui8>(value & 0xFF);
        type = (value & 0xF00) >> 8;
        switch (type) {
            case 1:
                m_shingle_type = KCFROM;
                break;
            case 2:
                m_shingle_type = KCMESS;
                break;
            case 3:
                m_shingle_type = KCSUBJECT;
                break;
            case 4:
                m_shingle_type = KCBEENSENDER;
                break;
            case 5:
                m_shingle_type = KCLIST;
                break;
            case 6:
                m_shingle_type = KCFROMDOMEN;
                break;
            case 7:
                m_shingle_type = KCRETURNPATH;
                break;
            case 8:
                m_shingle_type = KCPSNDR;
                break;
            case 9:
                m_shingle_type = KCPSNDR_NOFROM;
                break;
            case 0:
                m_shingle_type = KCUNKNOWN;
                break;
            default:
                m_shingle_type = KCUNKNOWN;
        };
    }
    ~TPackShingleType(){};

    ui32 PackValue() {
        ui32 res = 0;

        switch (m_shingle_type) {
            case KCFROM:
                res = (0x01 << 8) + m_value;
                break;
            case KCMESS:
                res = (0x02 << 8) + m_value;
                break;
            case KCSUBJECT:
                res = (0x03 << 8) + m_value;
                break;
            case KCBEENSENDER:
                res = (0x04 << 8) + m_value;
                break;
            case KCLIST:
                res = (0x05 << 8) + m_value;
                break;
            case KCFROMDOMEN:
                res = (0x06 << 8) + m_value;
                break;
            case KCRETURNPATH:
                res = (0x07 << 8) + m_value;
                break;
            case KCPSNDR:
                res = (0x08 << 8) + m_value;
                break;
            case KCPSNDR_NOFROM:
                res = (0x09 << 8) + m_value;
                break;
            case KCUNKNOWN:
                res = m_value;
                break;
            default:
                res = m_value;
        };

        return res;
    }

    TString PackValueS() {
        ui32 v = 0;
        char buff[32];

        v = PackValue();
        memset(buff, 0, sizeof(buff));
        snprintf(buff, sizeof(buff) - 1, "%u", v);

        return TString(buff);
    }

    TComplaintType ShingleType() {
        return m_shingle_type;
    }
    ui8 Value() {
        return m_value;
    }
    bool ValueB() {
        return (bool)m_value;
    }
    TComplSpamType ValueST() {
        return (TComplSpamType)m_value;
    }
    TString ValueS() {
        char buff[32];

        memset(buff, 0, sizeof(buff));
        snprintf(buff, sizeof(buff) - 1, "%u", m_value);

        return TString(buff);
    }
};

class TPackShingleType2 {
private:
    TStatType m_shingle_type;
    ui8 m_value;

public:
    TPackShingleType2() {
        m_shingle_type = KSUNKNOWN;
        m_value = 0;
    }
    TPackShingleType2(const TStatType& shingle_type, const ui8& value) {
        m_shingle_type = shingle_type;
        m_value = value;
    }
    TPackShingleType2(const TStatType& shingle_type, const int& value) {
        m_shingle_type = shingle_type;
        m_value = (ui8) value;
    }
    TPackShingleType2(const TStatType& shingle_type, const bool& value) {
        m_shingle_type = shingle_type;
        if (value)
            m_value = 1;
        else
            m_value = 0;
    }
    TPackShingleType2(const TStatType& shingle_type, const TComplSpamType& value) {
        m_shingle_type = shingle_type;
        m_value = value;
    }

    explicit TPackShingleType2(const ui32& value) {
        ui32 type = 0;

        m_value = static_cast<ui8>(value & 0xFF);
        type = (value & 0xF00) >> 8;
        switch (type) {
            case 1:
                m_shingle_type = KSFROM;
                break;
            case 2:
                m_shingle_type = KSBEENSENDER;
                break;
            case 3:
                m_shingle_type = KSLIST;
                break;
            case 0:
                m_shingle_type = KSUNKNOWN;
                break;
            default:
                m_shingle_type = KSUNKNOWN;
        };
    }
    ~TPackShingleType2(){};

    ui32 PackValue() {
        ui32 res = 0;

        switch (m_shingle_type) {
            case KSFROM:
                res = (0x01 << 8) + m_value;
                break;
            case KSBEENSENDER:
                res = (0x02 << 8) + m_value;
                break;
            case KSLIST:
                res = (0x03 << 8) + m_value;
                break;
            case KSUNKNOWN:
                res = m_value;
                break;
            default:
                res = m_value;
        };

        return res;
    }

    TString PackValueS() {
        ui32 v = 0;
        char buff[32];

        v = PackValue();
        memset(buff, 0, sizeof(buff));
        snprintf(buff, sizeof(buff) - 1, "%u", v);

        return TString(buff);
    }

    TStatType ShingleType() {
        return m_shingle_type;
    }
    ui8 Value() {
        return m_value;
    }
    bool ValueB() {
        return (bool)m_value;
    }
    TComplSpamType ValueST() {
        return (TComplSpamType)m_value;
    }
    TString ValueS() {
        char buff[32];

        memset(buff, 0, sizeof(buff));
        snprintf(buff, sizeof(buff) - 1, "%u", m_value);

        return TString(buff);
    }
};

//***************************************************************************************
//                            Other function
//***************************************************************************************

ui32 SGetStr(const char* source, ui32 source_size, char* destination, ui32 destination_size);

//***************************************************************************************
//                                  Host reputation
//***************************************************************************************

class THostShingle {
private:
    TString m_host;
    ui64 m_shingle;
    TString m_shingle_str;

public:
    THostShingle();
    THostShingle(ui64 shingle); //упрощенный конструктор, не использовать!!!
    THostShingle(const char* host);

    const char* Host() const {
        return m_host.c_str();
    }
    ui64 Shingle() const {
        return m_shingle;
    }
    const TString& Shingle_str() const {
        return m_shingle_str;
    }
};

class THostRequest {
private:
    THostShingle m_shingle;
    ui16 m_type;
    bool m_banpattrn;
    bool m_surbl;
    TShingleValue m_value;

    bool m_res_empty;      //данные из истории
    ui32 m_res_firsttime;  //данные из истории
    ui32 m_res_lasttime;   //данные из истории
    ui32 m_res_todaycount; //данные из истории
    ui32 m_res_banpattrn;  //данные из истории
    ui32 m_res_surbl;      //данные из истории

    bool m_res_todaydata_empty;     //данные из хэша "сегодня"
    ui32 m_res_todaydata_ham;       //данные из хэша "сегодня"
    ui32 m_res_todaydata_spam;      //данные из хэша "сегодня"
    ui32 m_res_todaydata_malic;     //данные из хэша "сегодня"
    ui32 m_res_todaydata_banpattrn; //данные из хэша "сегодня"
    ui32 m_res_todaydata_surbl;     //данные из хэша "сегодня"

    void ResClear();

public:
    THostRequest();
    THostRequest(THostShingle shingle, ui16 type, bool banpattrn, bool surbl, TShingleValue value);
    THostRequest(const char* host, ui16 type, bool banpattrn, bool surbl, TShingleValue value);
    THostRequest(ui64 shingle, ui16 type); //упрощенный конструктор, не использовать!!!

    THostShingle Shingle() const {
        return m_shingle;
    }
    const char* sShingle() const;
    const char* Host() const {
        return m_shingle.Host();
    }
    ui16 Type() const {
        return m_type;
    }
    bool Banpattrn() const {
        return m_banpattrn;
    }
    bool Surbl() const {
        return m_surbl;
    }
    TShingleValue Value() const {
        return m_value;
    }

    bool ResEmpty() const {
        return m_res_empty;
    } //данные из истории
    ui32 ResFirsttime() const {
        return m_res_firsttime;
    } //данные из истории
    ui32 ResLasttime() const {
        return m_res_lasttime;
    }                           //данные из истории
    ui32 ResFirsttimeElapsed() const; //данные из истории
    ui32 ResLasttimeElapsed() const;  //данные из истории
    ui32 ResTodaycount() const {
        return m_res_todaycount;
    } //данные из истории
    ui32 ResBanpattrn() const {
        return m_res_banpattrn;
    } //данные из истории
    ui32 ResSurbl() const {
        return m_res_surbl;
    } //данные из истории

    bool ResTodayDataEmpty() const {
        return m_res_todaydata_empty;
    } //данные из хэша "сегодня"
    ui32 ResTodayDataHam() const {
        return m_res_todaydata_ham;
    } //данные из хэша "сегодня"
    ui32 ResTodayDataSpam() const {
        return m_res_todaydata_spam;
    } //данные из хэша "сегодня"
    ui32 ResTodayDataMalic() const {
        return m_res_todaydata_malic;
    } //данные из хэша "сегодня"
    ui32 ResTodayDataBanpattrn() const {
        return m_res_todaydata_banpattrn;
    } //данные из хэша "сегодня"
    ui32 ResTodayDataSurbl() const {
        return m_res_todaydata_surbl;
    } //данные из хэша "сегодня"

    TString GetRequest() const;
    bool ResSetFromText(ui64 shingle, ui16 type, bool empty, TString& text);
};

typedef std::list<THostRequest> THostRequestList;
typedef THostRequestList::iterator THostRequestListIt;

//***************************************************************************************
//                                     FromTo
//***************************************************************************************

class TFromToShingle {
private:
    TString m_from;
    TString m_to;
    TString m_userid;
    TString m_shingle_str;
    ui64 m_shingle;
    TString m_userid_newuid;
    TString m_shingle_newuid_str;
    ui64 m_shingle_newuid;

public:
    TFromToShingle();
    TFromToShingle(ui64 shingle); //упрощенный конструктор, не использовать!!!
    TFromToShingle(const TStringBuf& from, const TStringBuf& userid, const TStringBuf& to);
    TFromToShingle(ui64 shingle, ui64 shingle_newuid); //упрощенный конструктор, не использовать!!!
    TFromToShingle(const TStringBuf& from, const TUserID& id, const TStringBuf& to);

    const char* From() const {
        return m_from.c_str();
    }
    const char* To() const {
        return m_to.c_str();
    }

    const char* Userid() const {
        return m_userid.c_str();
    }
    ui64 Shingle() const {
        return m_shingle;
    }
    const TString& Shingle_str() const {
        return m_shingle_str;
    }

    const char* UseridNewUid() const {
        return m_userid_newuid.c_str();
    }
    ui64 ShingleNewUid() const {
        return m_shingle_newuid;
    }
    const TString& ShingleNewUid_str() const {
        return m_shingle_newuid_str;
    }
};

class TFromToRequest {
private:
    TFromToShingle m_shingle;
    TKMailType m_value;

    bool m_res_empty;
    ui32 m_res_firsttime;
    ui32 m_res_lasttime;
    ui32 m_res_send;
    ui32 m_res_accepted;

    void ResClear();

public:
    TFromToRequest();
    TFromToRequest(ui64 shingle, TKMailType value);                      //упрощенный конструктор, не использовать!!!
    TFromToRequest(ui64 shingle, ui64 shingle_newuid, TKMailType value); //упрощенный конструктор, не использовать!!!
    TFromToRequest(TFromToShingle shingle, TKMailType value);            //применимы в качестве value: KOUTMAIL (KOUTMAILHAM, KOUTMAILSPAM) и KINMAIL (KINMAILHAM, KINMAILSPAM)
    TFromToRequest(const char* from, const char* userid, TKMailType value, const char* to);
    TFromToRequest(const char* from, const TUserID& id, TKMailType value, const char* to);

    const char* From() const {
        return m_shingle.From();
    }
    const char* To() const {
        return m_shingle.To();
    }
    TFromToShingle Shingle() const {
        return m_shingle;
    }

    const char* sShingle() const;
    const char* Userid() const {
        return m_shingle.Userid();
    }

    const char* sShingleNewUid() const;
    const char* UseridNewUid() const {
        return m_shingle.UseridNewUid();
    }

    TKMailType Value() const {
        return m_value;
    }
    bool ResEmpty() const {
        return m_res_empty;
    }
    ui32 ResFirsttime() {
        return m_res_firsttime;
    }
    ui32 ResLasttime() {
        return m_res_lasttime;
    }
    ui32 ResFirsttimeElapsed() const;
    ui32 ResLasttimeElapsed() const;
    ui32 ResSend() const {
        return m_res_send;
    }
    ui32 ResAccepted() const {
        return m_res_accepted;
    }

    TString GetRequest() const;
    bool ResSetFromText(ui64 shingle, bool empty, TString& text);
    bool ResSetFromText2(ui64 shingle_newuid, bool empty, TString& text);
    TString PrintData();
    TString PrintData2();
};

typedef std::list<TFromToRequest> TFromToRequestList;
typedef TFromToRequestList::iterator TFromToRequestListIt;

//***************************************************************************************
//                                  Complaints
//***************************************************************************************

class TComplaintShingle {
private:
    TString m_host;
    TString m_from;
    TString m_userid;
    TString m_shingle_str;
    ui64 m_shingle;
    TComplaintType m_type;
    TString m_new_userid;
    TString m_new_shingle_str;
    ui64 m_new_shingle;

    void Init(TZoneDetector& TDC, const TStringBuf& host, const TStringBuf& ip, const TStringBuf& from, const TStringBuf& userid, TComplaintType type, const TStringBuf& newuserid);
    TString GetHost(TZoneDetector& TDC, const TString& host, const TString& ip);
    TString GetHost2(TZoneDetector& TDC, const TString& host);
    TString RemoveDigitsFromHost(const TString& host);
    bool IsLocalhost(const TString& host);

public:
    TComplaintShingle();
    TComplaintShingle(ui64 shingle, TComplaintType type);                                                                                                                                                                               //упрощенный конструктор, не использовать!!!
    TComplaintShingle(ui64 shingle, TComplaintType type, ui64 newshingle);                                                                                                                                                              //упрощенный конструктор, не использовать!!!
    TComplaintShingle(ui64 shingle, TComplaintType type, const TString& suid, ui64 newshingle, const TString& uid);                                                                                                                     //упрощенный конструктор, не использовать!!!
    TComplaintShingle(TZoneDetector& TDC, const TStringBuf& host, const TStringBuf& ip, const TStringBuf& from, const TStringBuf& userid, TComplaintType type, const TStringBuf& newuserid);                                                                          //KCFROM, KCMESS, KCSUBJECT
    TComplaintShingle(TZoneDetector& TDC, const TStringBuf& host, const TStringBuf& ip, const TStringBuf& from, const TStringBuf& sender, const TStringBuf& xbeenwhere, const TStringBuf& deliveredto, const TStringBuf& userid, const TStringBuf& newuserid);     //KCBEENSENDER
    TComplaintShingle(TZoneDetector& TDC, const TStringBuf& host, const TStringBuf& ip, const TStringBuf& from, const TStringBuf& beenthere, const TStringBuf& deliveredto, TFieldListStrings& list, const TStringBuf& userid, const TStringBuf& newuserid); //KCLIST

    const char* Host() const {
        return m_host.c_str();
    }
    const char* From() const {
        return m_from.c_str();
    }
    const char* Mess() const {
        return m_from.c_str();
    }
    const char* Subject() const {
        return m_from.c_str();
    }
    const char* Userid() const {
        return m_userid.c_str();
    }
    const TString& Shingle_str() const {
        return m_shingle_str;
    }
    ui64 Shingle() const {
        return m_shingle;
    }
    const char* NewUserid() const {
        return m_new_userid.c_str();
    }
    const TString& NewShingle_str() const {
        return m_new_shingle_str;
    }
    ui64 NewShingle() const {
        return m_new_shingle;
    }
    TComplaintType Type() const {
        return m_type;
    }
};

#define MRC_AUTOACTION 0x00008000   //автоматическое действие (сброс, например); поле firsttime
#define MRC_MANUALACTION 0x00004000 //ручное действие (сброс, установка); поле firsttime
#define MRC_UNSUBSCRIBE 0x00008000  //признак, что пользователь хочет отписаться; поле lasttime
#define MRC_RESERVLT 0x00004000     //резервный бит; поле lasttime

#define SET_MRC_AUTOACTION(flag) \
    { (flag) |= MRC_AUTOACTION; }
#define SET_MRC_MANUALACTION(flag) \
    { (flag) |= MRC_MANUALACTION; }
#define SET_MRC_UNSUBSCRIBE(flag) \
    { (flag) |= MRC_UNSUBSCRIBE; }
#define SET_MRC_RESERVLT(flag) \
    { (flag) |= MRC_RESERVLT; }

#define IS_MRC_AUTOACTION(flag) ((flag)&MRC_AUTOACTION)
#define IS_MRC_MANUALACTION(flag) ((flag)&MRC_MANUALACTION)
#define IS_MRC_UNSUBSCRIBE(flag) ((flag)&MRC_UNSUBSCRIBE)
#define IS_MRC_RESERVLT(flag) ((flag)&MRC_RESERVLT)

#define RESET_MRC_AUTOACTION(flag) \
    { (flag) = (flag) & (~MRC_AUTOACTION); }
#define RESET_MRC_UNSUBSCRIBE(flag) \
    { (flag) = (flag) & (~MRC_UNSUBSCRIBE); }
#define RESET_MRC_RESERVLT(flag) \
    { (flag) = (flag) & (~MRC_RESERVLT); }

class TComplaintRequest {
private:
    TComplaintShingle m_shingle;
    TKMailType m_value;

    bool m_res_empty;
    ui32 m_res_firsttime;
    ui32 m_res_lasttime;
    ui32 m_res_complaint_ham;
    ui32 m_res_complaint_spam;
    ui32 m_res_ham;
    ui32 m_res_spam;
    ui32 m_res_history;
    ui32 m_res_replace_to_ham;
    ui32 m_res_replace_to_spam;
    ui32 m_res_lasttime_change;

    void ResClear();

public:
    TComplaintRequest();
    TComplaintRequest(ui64 shingle, TComplaintType type, TKMailType value);                                                                                                                                                                               //упрощенный конструктор, не использовать!!!
    TComplaintRequest(ui64 shingle, ui64 uidnew_shingle, TComplaintType type, TKMailType value);                                                                                                                                                          //упрощенный конструктор, не использовать!!!
    TComplaintRequest(TComplaintShingle shingle, TKMailType value);                                                                                                                                                                                       //применимы в качестве value: KINMAILHAM и KINMAILSPAM
    TComplaintRequest(TZoneDetector& TDC, const TStringBuf& host, const TStringBuf& ip, const TStringBuf& from, const TStringBuf& userid, TKMailType value, TComplaintType type, const TStringBuf& newuserid);                                                                          //KCFROM, KCMESS, KCSUBJECT
    TComplaintRequest(TZoneDetector& TDC, const TStringBuf& host, const TStringBuf& ip, const TStringBuf& from, const TStringBuf& sender, const TStringBuf& xbeenthere, const TStringBuf& deliveredto, const TStringBuf& userid, TKMailType value, const TStringBuf& newuserid);     //KCBEENSENDER
    TComplaintRequest(TZoneDetector& TDC, const TStringBuf& host, const TStringBuf& ip, const TStringBuf& from, const TStringBuf& beenthere, const TStringBuf& deliveredto, TFieldListStrings& list, const TStringBuf& userid, TKMailType value, const TStringBuf& newuserid); //KCLIST

    TComplaintShingle Shingle() const {
        return m_shingle;
    }
    const char* sShingle() const;
    const char* Host() const {
        return m_shingle.Host();
    }
    const char* From() const {
        return m_shingle.From();
    }
    const char* Userid() {
        return m_shingle.Userid();
    }
    const char* sShingleNew();
    const char* UseridNew() {
        return m_shingle.NewUserid();
    }
    TComplaintType Type() {
        return m_shingle.Type();
    }
    TKMailType Value() {
        return m_value;
    }
    bool ResEmpty() {
        return m_res_empty;
    }
    ui32 ResFirsttime();
    ui32 ResFullFirstTime() {
        return m_res_firsttime;
    } //with priznak
    ui32 ResLasttime();
    ui32 ResFullLasttime() {
        return m_res_lasttime;
    }
    ui32 ResFirsttimeElapsed();
    ui32 ResLasttimeElapsed();
    ui32 ResComplaintHam() {
        return m_res_complaint_ham;
    }
    ui32 ResComplaintSpam() {
        return m_res_complaint_spam;
    }
    ui32 ResHam();
    ui32 ResSpam();
    ui32 ResHistory() {
        return m_res_history;
    }
    ui32 ResReplaceToHam() {
        return m_res_replace_to_ham;
    }
    ui32 ResReplaceToSpam() {
        return m_res_replace_to_spam;
    }
    ui32 ResLasttimeChange() {
        return m_res_lasttime_change;
    }
    bool ResAutoAction() {
        return (bool)IS_MRC_AUTOACTION(m_res_firsttime);
    }
    bool ResManualAction() {
        return (bool)IS_MRC_MANUALACTION(m_res_firsttime);
    }
    bool ResUnsubscribe() {
        return (bool)IS_MRC_UNSUBSCRIBE(m_res_lasttime);
    }
    bool ResReservLT() {
        return (bool)IS_MRC_RESERVLT(m_res_lasttime);
    }

    TString GetRequest() const;
    TString GetRequestNew() const;
    TString GetCorrectRequest() const;    //вернуть запрос с откорректированным значением (спам на хам и наоборот)
    TString GetCorrectRequestNew() const; //вернуть запрос с откорректированным значением (спам на хам и наоборот)
    //void              ResSet(bool empty, ui16 firsttime, ui16 lasttime, ui8 complaint_ham, ui8 complaint_spam, ui8 ham, ui8 spam, ui32 history, ui8 replace_to_ham, ui8 replace_to_spam, ui16 lasttimechange);
    bool ResSetFromText(ui64 shingle, bool empty, TString& text);
    bool ResSetFromText2(ui64 shingle_newuid, bool empty, TString& text);

    TString PrintData();
    TString PrintData2();
};

typedef std::list<TComplaintRequest> TComplaintRequestList;
typedef TComplaintRequestList::iterator TComplaintRequestListIt;

//***************************************************************************************
//                                  From statistik
//***************************************************************************************

class TFromStatShingle {
private:
    TString m_from;
    TString m_shingle_str;
    ui64 m_shingle;
    TStatType m_type;

    void Init(const TStringBuf& from, TStatType m_typeA);

public:
    TFromStatShingle();
    TFromStatShingle(ui64 shingle, TStatType type);                                                                                   //упрощенный конструктор, не использовать!!!
    TFromStatShingle(const TStringBuf& from, TStatType type);                                                                               //all types
    TFromStatShingle(const TStringBuf& from, const TStringBuf& sender, const TStringBuf& xbeenwhere, const TStringBuf& deliveredto);     //KSBEENSENDER
    TFromStatShingle(const TStringBuf& from, const TStringBuf& beenthere, const TStringBuf& deliveredto, TFieldListStrings& list); //KSLIST

    const char* From() const {
        return m_from.c_str();
    }
    const TString& Shingle_str() const {
        return m_shingle_str;
    }
    ui64 Shingle() const {
        return m_shingle;
    }
    TStatType Type() const {
        return m_type;
    }
};

class TFromStatRequest {
private:
    TFromStatShingle m_shingle;
    TKMailType m_value;

    bool m_res_empty;
    ui32 m_res_firsttime;
    ui32 m_res_lasttime;
    ui32 m_res_complaint_ham;
    ui32 m_res_complaint_spam;
    ui32 m_res_ham;
    ui32 m_res_spam;
    ui32 m_res_history;
    ui32 m_res_replace_to_ham;
    ui32 m_res_replace_to_spam;
    ui32 m_res_uniquser_ham;
    ui32 m_res_uniquser_spam;
    ui32 m_res_uniquser;
    ui32 m_res_lasttime_change;

    void ResClear();

public:
    TFromStatRequest();
    TFromStatRequest(ui64 shingle, TStatType type, TKMailType value);     //упрощенный конструктор, не использовать!!!
    TFromStatRequest(const TStringBuf& from, TStatType type, TKMailType value); //all types
    //TFromStatRequest(const char *from, TKMailType value);                 //KSFROM
    TFromStatRequest(const TStringBuf& from, const TStringBuf& sender, const TStringBuf& xbeenwhere, const TStringBuf& deliveredto, TKMailType value);     //KSBEENSENDER
    TFromStatRequest(const TStringBuf& from, const TStringBuf& beenthere, const TStringBuf& deliveredto, TFieldListStrings& list, TKMailType value); //KSLIST

    TFromStatShingle Shingle() const {
        return m_shingle;
    }
    const char* sShingle() const;
    const char* From() const {
        return m_shingle.From();
    }
    TStatType Type() const {
        return m_shingle.Type();
    }
    TKMailType Value() const {
        return m_value;
    }
    bool ResEmpty() const {
        return m_res_empty;
    }
    ui32 ResFirsttime() const {
        return m_res_firsttime & 0x3FFF;
    } //младшие 14 бит
    ui32 ResLasttime() const {
        return m_res_lasttime;
    }
    ui32 ResFirsttimeElapsed() const;
    ui32 ResLasttimeElapsed() const;
    ui32 ResComplaintHam() const {
        return m_res_complaint_ham;
    }
    ui32 ResComplaintSpam() const {
        return m_res_complaint_spam;
    }
    ui32 ResHam() const;
    ui32 ResSpam() const;
    ui32 ResHistory() const {
        return m_res_history;
    }
    ui32 ResReplaceToHam() const {
        return m_res_replace_to_ham;
    }
    ui32 ResReplaceToSpam() const {
        return m_res_replace_to_spam;
    }
    ui32 ResUniquserHam() const {
        return m_res_uniquser_ham;
    }
    ui32 ResUniquserSpam() const {
        return m_res_uniquser_spam;
    }
    ui32 ResUniquser() const {
        return m_res_uniquser;
    }
    ui32 ResLasttimeChange() const {
        return m_res_lasttime_change;
    }
    bool ResAutoAction() const {
        return (bool)IS_MRC_AUTOACTION(m_res_firsttime);
    }
    bool ResManualAction() const {
        return (bool)IS_MRC_MANUALACTION(m_res_firsttime);
    }

    TString GetRequest() const;
    TString GetCorrectRequest() const; //вернуть запрос с откорректированным значением (спам на хам и наоборот)
    //void              ResSet(bool empty, ui16 firsttime, ui16 lasttime, ui32 complaint_ham, ui32 complaint_spam, ui32 ham, ui32 spam, ui32 history, ui32 replace_to_ham, ui32 replace_to_spam, ui32 uniquser_ham, ui32 uniquser_spam, ui32 uniquser, ui16 lasttimechange);
    bool ResSetFromText(ui64 shingle, bool empty, TString& text);
    TString PrintData() const;
    TString PrintData2() const;
};

typedef std::list<TFromStatRequest> TFromStatRequestList;
typedef TFromStatRequestList::iterator TFromStatRequestListIt;

//***************************************************************************************
//                                   TDLVShingles
//***************************************************************************************

class TDLVShingles {
private:
    ui64 m_shingle;
    ui8 m_type;
    TString m_shingle_str;

public:
    TDLVShingles();
    TDLVShingles(ui64 shingleA, ui8 typeA);

    const TString& Shingle_str() const {
        return m_shingle_str;
    }
    ui64 Shingle() const {
        return m_shingle;
    }
    ui8 Type() const {
        return m_type;
    }
};

class TDLVShinglesRequest {
private:
    TDLVShingles m_shingle;

    bool m_res_empty;
    ui32 m_res_ham;
    ui32 m_res_spam;
    ui32 m_res_pr;
    bool m_res_inwhitelist;
    ui32 m_res_today_ham;
    ui32 m_res_today_spam;
    ui32 m_res_yesterday_ham;
    ui32 m_res_yesterday_spam;
    //outmail
    float m_res_weight;
    ui32 m_res_exist_weight;
    ui32 m_res_time_set_weigth;
    ui32 m_res_last_set_weigth;
    ui32 m_res_setweigths_count;
    ui32 m_res_during;
    //inmail
    float m_res_weight_in;
    ui32 m_res_exist_weight_in;
    ui32 m_res_time_set_weigth_in;
    ui32 m_res_last_set_weigth_in;
    ui32 m_res_setweigths_count_in;
    ui32 m_res_during_in;

    void ResClear();

public:
    TDLVShinglesRequest();
    TDLVShinglesRequest(ui64 shingleA, ui8 typeA);
    TDLVShinglesRequest(const TStringBuf& shingleA, ui8 typeA);

    TDLVShingles Shingle() const {
        return m_shingle;
    } //шингл
    const char* sShingle() const;
    ui8 Type() const {
        return m_shingle.Type();
    } //тип
    bool ResEmpty() const {
        return m_res_empty;
    } //true - нет данных
    ui32 ResHam() const {
        return m_res_ham;
    } //хама
    ui32 ResSpam() const {
        return m_res_spam;
    } //спама
    ui32 ResPr() const {
        return m_res_pr;
    } //признаки
    //0x01 - находится в "белом" списке
    bool ResInWhiteList() const {
        return m_res_inwhitelist;
    } //шингл находится в "белом списке"
    ui32 ResTodayHam() const {
        return m_res_today_ham;
    } //хама сегодня
    ui32 ResTodaySpam() const {
        return m_res_today_spam;
    } //спама сегодня
    ui32 ResYesterdayHam() const {
        return m_res_yesterday_ham;
    } //хама вчера
    ui32 ResYesterdaySpam() const {
        return m_res_yesterday_spam;
    } //спама вчера

    //weigth
    double ResWeight(bool outmail) const {
        return outmail ? ResWeightOUT() : ResWeightIN();
    } //вес шингла (в зависимости от параметра: true - для исходящей почты, false - для входящей)
    ui32 ResExistWeight(bool outmail) const {
        return outmail ? ResExistWeightOUT() : ResExistWeightIN();
    } //true - есть вес
    ui32 ResTimeSetWeight(bool outmail) const {
        return outmail ? ResTimeSetWeightOUT() : ResTimeSetWeightIN();
    } //время установки текущего веса
    ui32 ResLastSetWeight(bool outmail) const {
        return outmail ? ResLastSetWeightOUT() : ResLastSetWeightIN();
    } //время установки предыдущего веса
    ui32 ResSetWeigthsCount(bool outmail) const {
        return outmail ? ResSetWeigthsCountOUT() : ResSetWeigthsCountIN();
    } //сколько раз устанавливали вес
    ui32 ResWeightDuring(bool outmail) const {
        return outmail ? ResWeightDuringOUT() : ResWeightDuringIN();
    } //продолжительность установленного веса
    //outmail
    float ResWeightOUT() const {
        return m_res_weight;
    } //вес шингла для исходящей почты
    ui32 ResExistWeightOUT() const {
        return m_res_exist_weight;
    } //true - есть вес
    ui32 ResTimeSetWeightOUT() const {
        return m_res_time_set_weigth;
    } //время установки текущего веса
    ui32 ResLastSetWeightOUT() const {
        return m_res_last_set_weigth;
    } //время установки предыдущего веса
    ui32 ResSetWeigthsCountOUT() const {
        return m_res_setweigths_count;
    } //сколько раз устанавливали вес
    ui32 ResWeightDuringOUT() const {
        return m_res_during;
    } //продолжительность установленного веса
    //inmail
    float ResWeightIN() const {
        return m_res_weight_in;
    } //вес шингла для входящей почты
    ui32 ResExistWeightIN() const {
        return m_res_exist_weight_in;
    } //true - есть вес
    ui32 ResTimeSetWeightIN() const {
        return m_res_time_set_weigth_in;
    } //время установки текущего веса
    ui32 ResLastSetWeightIN() const {
        return m_res_last_set_weigth_in;
    } //время установки предыдущего веса
    ui32 ResSetWeigthsCountIN() const {
        return m_res_setweigths_count_in;
    } //сколько раз устанавливали вес
    ui32 ResWeightDuringIN() const {
        return m_res_during_in;
    } //продолжительность установленного веса

    TString GetRequest() const;
    bool ResSetFromText(ui64 shingle, ui16 type, bool empty, TString& text);
    TString PrintData() const;
};

typedef std::list<TDLVShinglesRequest> TDLVShinglesRequestList;
typedef TDLVShinglesRequestList::iterator TDLVShinglesRequestListIt;

//*************************************************************************************************************************
//                                               TShinglesGroupClass
//*************************************************************************************************************************

struct TParsedShingleData {
    ui64 shingle;
    ui8 type;
    ui16 spam;
    ui16 ham;

    TParsedShingleData() {
        shingle = 0;
        type = 0;
        spam = 0;
        ham = 0;
    }

    TParsedShingleData(ui64 shingleA, ui8 typeA, ui16 spamA, ui16 hamA) {
        shingle = shingleA;
        type = typeA;
        spam = spamA;
        ham = hamA;
    }
};

typedef std::list<TParsedShingleData> TParsedShingleDataList;
typedef TParsedShingleDataList::iterator TParsedShingleDataListIt;

//*************************************************************************************************************************
//                                  TComplaintFromUser
//*************************************************************************************************************************

class TComplaintFromUser {
private:
    bool m_enb{};
    TString m_login;
    TString m_suid;
    TString m_ip;
    TString m_data;
    TString m_type;
    TString m_move;
    TString m_mail;
    TString m_dlvlog;

    bool IsGood() const;

public:
    TComplaintFromUser() = default;

    bool SetParams(const TString& login, const TString& suid, const TString& ip, const TString& tsCompl, const TString& type, const TString& move, const TString& mail, const TString& dlvlog);
    TString GetType() const;
    TString GetTypeStr() const;
    TString GetComplainee() const;
};

//*************************************************************************************************************************
//                                  TParseResponce
//*************************************************************************************************************************

struct TParseResponce {
    TResponceType resptype = KTUNKNOWN;
    ui64 shingle{};
    ui64 shingle2{};
    int type{};
    bool empty = true;
    TString body;
    TString stat;
    TString profile;

    TParseResponce() = default;

    explicit TParseResponce(const TString& text) {
        ParseResponce(text);
    }

    void ParseResponce(const TString& text);
};

//****************************************************************************************

class TShinglesGroupClass: public TMoveOnly {
public:
    bool definespam{}; //true - было задано поле spam
    //шинглы жалобщика (userid (suid) жалобщика)
    ui64 from_shingle{};               //KCFROM by suid
    ui64 fromdomen_shingle{};          //KCFROMDOMEN by suid
    ui64 returnpath_shingle{};         //KCRETURNPATH by suid
    ui64 mess_shingle{};               //KCMESS by suid
    ui64 subj_shingle{};               //KCSUBJECT by suid
    ui64 beensender_compl_shingle{};   //KCBEENSENDER by suid
    ui64 list_compl_shingle{};         //KCLIST by suid
    ui64 psndr_compl_shingle{};        //KCPSNDR by suid
    ui64 psndr_nofrom_compl_shingle{}; //KCPSNDR_NOFROM by suid

    //шинглы сборщика (userid (suid) из поля "x-yandex-suid:")
    ui64 from_shingle_coll{};               //KCFROM by suid
    ui64 fromdomen_shingle_coll{};          //KCFROMDOMEN by suid
    ui64 returnpath_shingle_coll{};         //KCRETURNPATH by suid
    ui64 mess_shingle_coll{};               //KCMESS by suid
    ui64 subj_shingle_coll{};               //KCSUBJECT by suid
    ui64 beensender_compl_shingle_coll{};   //KCBEENSENDER by suid
    ui64 list_compl_shingle_coll{};         //KCLIST by suid
    ui64 psndr_compl_shingle_coll{};        //KCPSNDR by suid
    ui64 psndr_nofrom_compl_shingle_coll{}; //KCPSNDR_NOFROM by suid

    //статистические шинглы
    ui64 from_shingle_stat{};       //KSFROM
    ui64 beensender_stat_shingle{}; //KSBEENSENDER
    ui64 list_stat_shingle{};       //KSLIST

    //для shinglestorage
    TString messid;                 //парсим из заголовков жалобы ("message-id:")
    TString queueid;                //парсим из заголовков жалобы ("x-yandex-queueid:")
    TString from;                   //парсим из заголовков жалобы ("from:")
    TComplSpamType spam = CS_HAM;   //тип жалобы (спам, хам, отписаться и т.д.)
    time_t data{};                  //дата жалобы (приходит вместе с жалобой)
    TUserID id;                     //id того, кто пожаловался (приходит вместе с жалобой)
    time_t dlv_time{};              //время проверки письма (парсим из dlv-лога проверки письма, на которое потом пожаловались)
    TParsedShingleDataList shlist;  //данные по шинглам (парсим из dlv-лога проверки письма, на которое потом пожаловались)
    TUserID sender_id;              //id отправителя письма (парсим из dlv-лога проверки письма, на которое потом пожаловались)
    TString complaint_id;           //идентификатор проверки жалобы, чтобы найти концы с концами по разным сервисам
    TString spamHdr;
    TString psnd;                   //платный рассыльщик
    TComplSource compl_src = SRC_UNKNOWN; //complaint source

    bool IsGoodData(TString& err_id) const;

    ui32 ui_flags{};
    int karma = -1;

    TComplaintFromUser pcomplUserdata;
    TString CreateRequestToLongshinglerA(TString& errtext);

public:
    TShinglesGroupClass() = default;

    TString CreateRequestToLongshinglerWOUid(TString& errtext);

    void SetUserKarma(int param_karma) {
        karma = param_karma;
    };

    //Вызов ф-ии обязателен!!!
    bool SetComplData(const TString& messidA, const TString& queueidA, TComplSpamType spamA, time_t dateA, const TUserID& idA,
                      time_t dlv_timeA, const TString& fromA, const TUserID& sender_idA, const TString& complaint_idA,
                      const TString& spmHdr, ui32 uiFlags, const TString& psndA);

    //возвращает true, если все ок, false, если какое-то из полей задано не верно
    //messidA       - парсим из заголовков жалобы ("message-id:")                                                - ОБЯЗАТЕЛЬНО!
    //queueidA      - парсим из заголовков жалобы ("x-yandex-queueid:")
    //spamA         - true - жалоба на спам (приходит вместе с жалобой)                                          - ОБЯЗАТЕЛЬНО!
    //dateA         - дата жалобы (приходит вместе с жалобой)                                                    - ОБЯЗАТЕЛЬНО!
    //idA           - id того, кто пожаловался (приходит вместе с жалобой)                                       - ОБЯЗАТЕЛЬНО!
    //dlv_timeA     - время проверки письма (парсим из dlv-лога проверки письма, на которое потом пожаловались)  - ОБЯЗАТЕЛЬНО!
    //fromA         - парсим из заголовков жалобы ("from:")
    //sender_idA    - id отправителя письма (парсим из dlv-лога проверки письма, на которое потом пожаловались)
    //complaint_idA - идентификатор проверки жалобы, чтобы найти концы с концами по разным сервисам
    //spamHdr       - значение X-Yandex-Spam в письме, на которое жалоба
    //psndA         - платный рассыльщик, задается, если есть

    //Добавляем шинглы из delivery лога проверки письма, на которое пожаловались
    void AddCheckShingle(ui64 shingle, ui8 type, ui16 spamcount, ui16 hamcount) {
        shlist.push_back(TParsedShingleData(shingle, type, spamcount, hamcount));
    }

    //Добавляем шинглы персональных фильтров (шинглы заданы как ui64)
    void SetFromShingle(ui64 from_shingleA) {
        from_shingle = from_shingleA;
    }
    void SetFromdomenShingle(ui64 fromdomen_shingleA) {
        fromdomen_shingle = fromdomen_shingleA;
    }
    void SetReturnpathShingle(ui64 returnpath_shingleA) {
        returnpath_shingle = returnpath_shingleA;
    }
    void SetMessShingle(ui64 mess_shingleA) {
        mess_shingle = mess_shingleA;
    }
    void SetSubjShingle(ui64 subj_shingleA) {
        subj_shingle = subj_shingleA;
    }
    void SetBeensenderShingle(ui64 beensender_compl_shingleA) {
        beensender_compl_shingle = beensender_compl_shingleA;
    }
    void SetListShingle(ui64 list_compl_shingleA) {
        list_compl_shingle = list_compl_shingleA;
    }
    void SetPsndrShingle(ui64 psndr_compl_shingleA) {
        psndr_compl_shingle = psndr_compl_shingleA;
    }
    void SetPsndrNofromShingle(ui64 psndrnofrom_compl_shingleA) {
        psndr_nofrom_compl_shingle = psndrnofrom_compl_shingleA;
    }

    void SetFromShingleColl(ui64 from_shingleA) {
        from_shingle_coll = from_shingleA;
    }
    void SetFromdomenShingleColl(ui64 fromdomen_shingleA) {
        fromdomen_shingle_coll = fromdomen_shingleA;
    }
    void SetReturnpathShingleColl(ui64 returnpath_shingleA) {
        returnpath_shingle_coll = returnpath_shingleA;
    }
    void SetMessShingleColl(ui64 mess_shingleA) {
        mess_shingle_coll = mess_shingleA;
    }
    void SetSubjShingleColl(ui64 subj_shingleA) {
        subj_shingle_coll = subj_shingleA;
    }
    void SetBeensenderShingleColl(ui64 beensender_compl_shingleA) {
        beensender_compl_shingle_coll = beensender_compl_shingleA;
    }
    void SetListShingleColl(ui64 list_compl_shingleA) {
        list_compl_shingle_coll = list_compl_shingleA;
    }
    void SetPsndrShingleColl(ui64 psndr_compl_shingleA) {
        psndr_compl_shingle_coll = psndr_compl_shingleA;
    }
    void SetPsndrNofromShingleColl(ui64 psndrnofrom_compl_shingleA) {
        psndr_nofrom_compl_shingle_coll = psndrnofrom_compl_shingleA;
    }

    void SetFromShingleStat(ui64 from_shingle_statA) {
        from_shingle_stat = from_shingle_statA;
    }
    void SetBeensenderShingleStat(ui64 beensender_stat_shingleA) {
        beensender_stat_shingle = beensender_stat_shingleA;
    }
    void SetListShingleStat(ui64 list_stat_shingleA) {
        list_stat_shingle = list_stat_shingleA;
    }

    void SetPaySender(TString& psndA) {
        psnd = psndA;
    }
};

//****************************************************************************************

#endif
