#pragma once

#ifndef ktime_H
#define ktime_H

#include <ctime>
#include <util/ysaveload.h>
#include "util/system/defaults.h"

#define KDAY_TIME_BASE 946674000

class kday_t {
private:
    ui16 t;

public:

    Y_SAVELOAD_DEFINE(t)

    kday_t() {
        t = 0;
    }

    explicit kday_t(const time_t& tvalue) {
        time_t tt = 0;

        if (tvalue > KDAY_TIME_BASE)
            tt = tvalue - KDAY_TIME_BASE;
        else
            tt = 0;
        t = (ui16)((tt / 86400) & 0xFFFF);
    }
    explicit kday_t(const unsigned long& tvalue) {
        t = (ui16)(tvalue & 0xFFFF);
    }
    ~kday_t() = default;;

    explicit operator time_t() const {
        return ((time_t)(86400 * t) + KDAY_TIME_BASE);
    }

    explicit operator ui32() const {
        return t;
    }

    explicit operator ui16() const {
        return t;
    }
};

#endif
