#pragma once


#include <mail/so/spamstop/tools/so-clients/general_shingler_get.h>
#include <mail/so/spamstop/tools/so-clients/general_shingler_put.h>
#include <util/generic/bt_exception.h>
#include "tsenderrepenv2.h"

namespace NSenderReputation{

    inline void FillKeysFromEmail(const TShingle& shingle, NJson::TJsonValue & fields) {
        if(shingle.ShingleEmail().Defined()) {
            fields["sendertype"] = 1;
            fields["hash"] = *shingle.ShingleEmail();
        }
    }
    inline void FillKeysFromDomain(const TShingle& shingle, NJson::TJsonValue & fields) {
        if(shingle.ShingleDomain().Defined()) {
            fields["sendertype"] = 2;
            fields["hash"] = *shingle.ShingleDomain();
        }
    }
    inline void FillKeysFromPsndr(const TShingle& shingle, NJson::TJsonValue & fields) {
        if(shingle.ShinglePSndr().Defined()) {
            fields["sendertype"] = 3;
            fields["hash"] = *shingle.ShinglePSndr();
        }
    }

    inline void FillTotalsFromInmail(const TPutDataInMail& data, NJson::TJsonValue & fields) {
        if(data.GetSpam())
            fields["sc"] = 1;
        else
            fields["hc"] = 1;

        if(data.GetMask())
            fields["fl"] = data.GetMask();


        switch (data.GetPers()) {
            case PA_NONE:
                break;
            case PA_PERSSPAM:
                fields["ps"] = 1;
                break;
            case PA_PERSHAM:
                fields["ph"] = 1;
                break;
        }

        if(data.GetAbook())
            fields["ab"] = 1;

        if(data.GetKooba())
            fields["ba"] = 1;

        if(data.GetPop3Spam().Defined()) {
            if(data.GetPop3Spam().GetRef()) {
                fields["pop3_spam"] = 1;
            } else {
                fields["pop3_ham"] = 1;
            }
        }

        if(data.GetDkimSpam().Defined()) {
            if(data.GetDkimSpam().GetRef()) {
                fields["dkim_spam"] = 1;
            } else {
                fields["dkim_ham"] = 1;
            }
        }

        if(data.GetPsSpam().Defined()) {
            if(data.GetPsSpam().GetRef()) {
                fields["ps_spam"] = 1;
            } else {
                fields["ps_ham"] = 1;
            }
        }
    }

    inline void FillWeeksFromInmail(const TPutDataInMail& data, NJson::TJsonValue & fields) {
        if(data.GetSpam())
            fields["spam"] = 1;
        else
            fields["ham"] = 1;

        switch (data.GetPers()) {
            case PA_NONE:
                break;
            case PA_PERSSPAM:
                fields["pers_spam"] = 1;
                break;
            case PA_PERSHAM:
                fields["pers_ham"] = 1;
                break;
        }

        if(data.GetAbook())
            fields["abook"] = 1;

        if(data.GetKooba())
            fields["kooba"] = 1;

        if(data.GetPop3Spam().Defined()) {
            if(data.GetPop3Spam().GetRef()) {
                fields["pop3_spam"] = 1;
            } else {
                fields["pop3_ham"] = 1;
            }
        }

        if(data.GetDkimSpam().Defined()) {
            if(data.GetDkimSpam().GetRef()) {
                fields["dkim_spam"] = 1;
            } else {
                fields["dkim_ham"] = 1;
            }
        }

        if(data.GetPsSpam().Defined()) {
            if(data.GetPsSpam().GetRef()) {
                fields["ps_spam"] = 1;
            } else {
                fields["ps_ham"] = 1;
            }
        }
    }

    inline void FillTotalsFromComplaint(const TComplaintData& data, NJson::TJsonValue & fields) {
        if(data.GetSpam())
            fields["cs"] = 1;
        else
            fields["ch"] = 1;

        if(data.GetDKimSpam().Defined() && *data.GetDKimSpam().Get())
            fields["dkim_complaint_spam"] = 1;
    }

    inline void FillWeeksFromComplaint(const TComplaintData& data, NJson::TJsonValue & fields) {
        if(data.GetSpam())
            fields["compl_spam"] = 1;
        else
            fields["compl_ham"] = 1;
    }

    class TGeneralGetRequest: public NGeneralShingler::TGetRequest {
    public:

        void ParseAnswer(const NJson::TJsonValue & v) override {

            data = {};
            TSender * links[] = { &data.sender, &data.domain, &data.psndr};

            THashMap<size_t , TDeque<const NJson::TJsonValue*>> weekCountersByType;
            for(const auto & js : v.GetArraySafe()) {
                const auto &scheme = js["scheme"].GetStringSafe();

                if (scheme == "sender_totals") {

                    for (const auto &res : js["find"].GetArraySafe()) {
                        auto senderType = res["sendertype"].GetUIntegerRobust();

                        TSender & target = *links[senderType-1];

                        target.totals.FromJson(res);
                    }
                } else if(scheme == "sender_2weeks") {
                    for (const auto &res : js["find"].GetArraySafe()) {
                        auto senderType = res["sendertype"].GetUIntegerRobust();
                        weekCountersByType[senderType].emplace_back(&res);
                    }
                }
            }
            const ui16 day = static_cast<ui16>(kday_t(time(nullptr)));
            const auto week2 = static_cast<const ui16>(day / 14);

            for(auto & counters : weekCountersByType) {
                switch (counters.second.size()) {
                    case 0:
                        counters.second.resize(2);
                        break;
                    case 1:
                        if((*counters.second.front())["week"].GetUIntegerRobust() == week2)
                            counters.second.emplace_back();
                        else
                            counters.second.emplace_front();
                        break;
                    default:
                        std::sort(counters.second.begin(), counters.second.end(), [](const NJson::TJsonValue* v1, const NJson::TJsonValue* v2){
                            return (*v1)["week"].GetUIntegerRobust() > (*v2)["week"].GetUIntegerRobust();
                        });
                        break;
                }
            }

            for(auto & counters : weekCountersByType) {

                TDBPeriodicSender cur, prev;

                if(counters.second[0])
                    cur.FromJson(*counters.second[0]);
                if(counters.second[1])
                    prev.FromJson(*counters.second[1]);

                TSender & target = *links[counters.first-1];
                target.periodic = TDBPeriodicSender::Interpolate(cur, prev, static_cast<ui16>(kday_t(time(nullptr))));
            }

        }

        explicit TGeneralGetRequest(const TShingle& shingle) : shingle(shingle) {
            {
                NJson::TJsonValue::TArray fieldsArray(1);

                auto & sendertypeArr = fieldsArray.front()["sendertype"].SetType(NJson::JSON_ARRAY).GetArraySafe();
                auto & hashArr = fieldsArray.front()["hash"].SetType(NJson::JSON_ARRAY).GetArraySafe();

                if(shingle.ShingleEmail().Defined()) {
                    sendertypeArr.emplace_back(1);
                    hashArr.emplace_back(*shingle.ShingleEmail());
                }
                if(shingle.ShingleDomain().Defined()) {
                    sendertypeArr.emplace_back(2);
                    hashArr.emplace_back(*shingle.ShingleDomain());
                }
                if(shingle.ShinglePSndr().Defined()) {
                    sendertypeArr.emplace_back(3);
                    hashArr.emplace_back(*shingle.ShinglePSndr());
                }

                AddMessage("sender_totals", std::move(fieldsArray));
            }
            {
                NJson::TJsonValue::TArray fieldsArray(1);

                auto & sendertypeArr = fieldsArray.front()["sendertype"].SetType(NJson::JSON_ARRAY).GetArraySafe();
                auto & hashArr = fieldsArray.front()["hash"].SetType(NJson::JSON_ARRAY).GetArraySafe();

                fieldsArray.front()["week"] = 1;

                if(shingle.ShingleEmail().Defined()) {
                    sendertypeArr.emplace_back(1);
                    hashArr.emplace_back(*shingle.ShingleEmail());
                }
                if(shingle.ShingleDomain().Defined()) {
                    sendertypeArr.emplace_back(2);
                    hashArr.emplace_back(*shingle.ShingleDomain());
                }
                if(shingle.ShinglePSndr().Defined()) {
                    sendertypeArr.emplace_back(3);
                    hashArr.emplace_back(*shingle.ShinglePSndr());
                }

                AddMessage("sender_2weeks", std::move(fieldsArray));
            }
        }

        const TGetData& getData() const { return data; }

        TGetData& getDataMutable() { return data; }

    private:
        TShingle shingle{};
        TGetData data{};
    };

    class TGeneralPutInMail : public NGeneralShingler::TPutRequest {
    public:
        explicit TGeneralPutInMail(const TShingle& shingle, const TPutDataInMail& data) {
            {
                NJson::TJsonValue::TArray fieldsArray;

                if(shingle.ShingleEmail().Defined()) {
                    auto & f = fieldsArray.emplace_back();
                    FillKeysFromEmail(shingle, f);
                    FillTotalsFromInmail(data, f);
                }
                if(shingle.ShingleDomain().Defined()) {
                    auto & f = fieldsArray.emplace_back();
                    FillKeysFromDomain(shingle, f);
                    FillTotalsFromInmail(data, f);
                }
                if(shingle.ShinglePSndr().Defined()) {
                    auto & f = fieldsArray.emplace_back();
                    FillKeysFromPsndr(shingle, f);
                    FillTotalsFromInmail(data, f);
                }

                AddMessage("sender_totals", std::move(fieldsArray));
            }
            {
                NJson::TJsonValue::TArray fieldsArray;

                if(shingle.ShingleEmail().Defined()) {
                    auto & f = fieldsArray.emplace_back();
                    FillKeysFromEmail(shingle, f);
                    f["ad"] = 1;
                }
                if(shingle.ShingleDomain().Defined()) {
                    auto & f = fieldsArray.emplace_back();
                    FillKeysFromDomain(shingle, f);
                    f["ad"] = 1;
                }
                if(shingle.ShinglePSndr().Defined()) {
                    auto & f = fieldsArray.emplace_back();
                    FillKeysFromPsndr(shingle, f);
                    f["ad"] = 1;
                }

                AddMessage("sender_ad", std::move(fieldsArray));
            }
            {
                NJson::TJsonValue::TArray fieldsArray;

                if(shingle.ShingleEmail().Defined()) {
                    auto & f = fieldsArray.emplace_back();
                    FillKeysFromEmail(shingle, f);
                    FillWeeksFromInmail(data, f);
                }
                if(shingle.ShingleDomain().Defined()) {
                    auto & f = fieldsArray.emplace_back();
                    FillKeysFromDomain(shingle, f);
                    FillWeeksFromInmail(data, f);
                }
                if(shingle.ShinglePSndr().Defined()) {
                    auto & f = fieldsArray.emplace_back();
                    FillKeysFromPsndr(shingle, f);
                    FillWeeksFromInmail(data, f);
                }

                AddMessage("sender_2weeks", std::move(fieldsArray));
            }
        }
    };

    class TGeneralPutOutMail : public NGeneralShingler::TPutRequest {
    public:
        explicit TGeneralPutOutMail(const TPutDataOutMail& data) {
            {
                NJson::TJsonValue::TArray fieldsArray;

                for(const auto & shingle : data) {
                    if(shingle.ShingleEmail().Defined()) {
                        auto & f = fieldsArray.emplace_back();
                        FillKeysFromEmail(shingle, f);
                        f["ry"] = 1;
                    }
                    if(shingle.ShingleDomain().Defined()) {
                        auto & f = fieldsArray.emplace_back();
                        FillKeysFromDomain(shingle, f);
                        f["ry"] = 1;
                    }
                    if(shingle.ShinglePSndr().Defined()) {
                        auto & f = fieldsArray.emplace_back();
                        FillKeysFromPsndr(shingle, f);
                        f["ry"] = 1;
                    }
                }

                AddMessage("sender_totals", std::move(fieldsArray));
            }
        }
    };

    class TGeneralPutComplaint : public NGeneralShingler::TPutRequest {
    public:
        bool empty() const override {
            return emailDate < Now() - TDuration::Days(14);
        };
        explicit TGeneralPutComplaint(const TShingle& shingle, const TComplaintData& data, const TInstant& emailDate) : emailDate(emailDate) {
            {
                NJson::TJsonValue::TArray fieldsArray;

                if(shingle.ShingleEmail().Defined()) {
                    auto & f = fieldsArray.emplace_back();
                    FillKeysFromEmail(shingle, f);
                    FillTotalsFromComplaint(data, f);
                }
                if(shingle.ShingleDomain().Defined()) {
                    auto & f = fieldsArray.emplace_back();
                    FillKeysFromDomain(shingle, f);
                    FillTotalsFromComplaint(data, f);
                }
                if(shingle.ShinglePSndr().Defined()) {
                    auto & f = fieldsArray.emplace_back();
                    FillKeysFromPsndr(shingle, f);
                    FillTotalsFromComplaint(data, f);
                }
                AddMessage("sender_totals", std::move(fieldsArray));
            }

            {
                NJson::TJsonValue::TArray fieldsArray;

                if(shingle.ShingleEmail().Defined()) {
                    auto & f = fieldsArray.emplace_back();
                    FillKeysFromEmail(shingle, f);
                    FillWeeksFromComplaint(data, f);
                }
                if(shingle.ShingleDomain().Defined()) {
                    auto & f = fieldsArray.emplace_back();
                    FillKeysFromDomain(shingle, f);
                    FillWeeksFromComplaint(data, f);
                }
                if(shingle.ShinglePSndr().Defined()) {
                    auto & f = fieldsArray.emplace_back();
                    FillKeysFromPsndr(shingle, f);
                    FillWeeksFromComplaint(data, f);
                }
                AddMessage("sender_2weeks", std::move(fieldsArray));
            }
        }

    private:
        TInstant emailDate;
    };
} // namespace NSenderReputation
