#include "tcacheshinglerenv.h"

#include <util/generic/vector.h>
#include <util/stream/str.h>
#include <util/stream/format.h>
#include <library/cpp/string_utils/base64/base64.h>
#include <mail/so/spamstop/tools/so-common/sobase64.h>
#include <mail/so/spamstop/tools/so-common/sputil.h>
#include <util/generic/bt_exception.h>
#include <util/stream/buffer.h>

namespace NCacheShingler {
    void TGetRequest::ParseAnswer(const NJson::TJsonValue & value) {
        //[{"find":[{"key":42,"value":"Test3"}],"scheme":"cache"}]
        const auto& allValues = value.GetArraySafe();

        if(allValues.empty())
            return;

        const auto& find = allValues.front()["find"].GetArraySafe();

        if(find.empty())
            return;

        const auto& targetVal = find.front();

        const auto & encoded = targetVal["answer"].GetStringRobust();

        const TString decoded = Base64Decode(encoded);

        TStringInput stream(decoded);

        TCheckedMessage checked;
        ::Load(&stream, checked);

        data = std::move(checked);
    }

    TMaybe<TCheckedMessage>& TGetRequest::GetCacheData() {
        return data;
    }

    TGetRequest::TGetRequest(ui64 shingle) {
        NJson::TJsonValue::TArray fields(1);

        NJson::TJsonValue & val = fields.front();

        val["shingle"] = shingle;

        AddMessage("cache", std::move(fields));
    }

    TPuRequest::TPuRequest(ui64 shingle, const TCheckedMessage& checked) {
        NJson::TJsonValue::TArray fields(1);

        NJson::TJsonValue & val = fields.front();

        val["shingle"] = shingle;

        TString encoded;
        {
            TStringStream buffer;
            ::Save(&buffer, checked);

            Base64Encode(buffer.Str(), encoded);
        }
        val["answer"] = std::move(encoded);

        AddMessage("cache", std::move(fields));
    }

} //    namespace CacheShingler
