#pragma once

#include <utility>
#include <util/generic/string.h>
#include <util/datetime/base.h>
#include <mail/so/spamstop/tools/so-common/so_answer.h>
#include "general_shingler_put.h"
#include "general_shingler_get.h"

namespace NCacheShingler {
    class TGetRequest: public NGeneralShingler::TGetRequest {
    public:
        void ParseAnswer(const NJson::TJsonValue & value) override;

        TMaybe<TCheckedMessage>& GetCacheData();

        explicit TGetRequest(ui64 shingle);

    private:
        TMaybe<TCheckedMessage> data;
    };

    class TPuRequest: public NGeneralShingler::TPutRequest {
    public:
        explicit TPuRequest(ui64 shingle, const TCheckedMessage& checked);
    };
} //    namespace CacheShingler

